<?php
  include '../dbConn.php';
  include 'checkLogin.php';
  include 'menus.php';

  $user_avatar = $loggedUserData['user_avatar'];
  $customerToken = $_SESSION["customerToken"];
?>

<!doctype html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang=""> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>ASRL Portal</title>
    <meta name="description" content="Ela Admin - HTML5 Admin Template">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="https://marketappz.com/asrl/admin/images/favicon.png">
    <link rel="shortcut icon" href="https://marketappz.com/asrl/admin/images/favicon.png">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/normalize.css@8.0.0/normalize.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/lykmapipo/themify-icons@0.1.2/css/themify-icons.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/pixeden-stroke-7-icon@1.2.3/pe-icon-7-stroke/dist/pe-icon-7-stroke.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.2.0/css/flag-icon.min.css">
    <link rel="stylesheet" href="assets/css/cs-skin-elastic.css">
    <link rel="stylesheet" href="assets/css/lib/datatable/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/custom.css">

    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="assets/css/lib/chosen/chosen.min.css">

    <!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv.min.js"></script> -->
    <style media="screen">
      .success-msg{
        display: none;
      }
      #segmentUsers{
        max-height: 100px;
        overflow-y: scroll;
        background: #f1f0f0;
        padding: 10px 0;
      }
      #segmentCurrentUsers,#search_teams,#search_state,#search_venue{
        display: none;
      }
    </style>
</head>
<body>
    <!-- Left Panel -->

    <aside id="left-panel" class="left-panel">
        <nav class="navbar navbar-expand-sm navbar-default">

            <div id="main-menu" class="main-menu collapse navbar-collapse">
                <?php displayMainMenu(); ?>
            </div><!-- /.navbar-collapse -->
        </nav>
    </aside><!-- /#left

    <!-- Left Panel -->

    <!-- Right Panel -->

    <div id="right-panel" class="right-panel">

        <!-- Header-->
        <header id="header" class="header">
            <div class="top-left">
                <div class="navbar-header">
                    <a class="navbar-brand" href="./"><img src="images/logo.png" alt="Logo"></a>
                    <a class="navbar-brand hidden" href="./"><img src="images/logo2.png" alt="Logo"></a>
                    <a id="menuToggle" class="menutoggle"><i class="fa fa-bars"></i></a>
                </div>
            </div>
            <div class="top-right">
                <div class="header-menu">
                    <div class="header-left">
                    </div>

                    <div class="user-area dropdown float-right">
                        <a href="#" class="dropdown-toggle active" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <img class="user-avatar rounded-circle" src="<?php echo $user_avatar; ?>" alt="User Avatar">
                        </a>

                        <?php displayProfileMenu(); ?>

                    </div>
                </div>
            </div>
        </header><!-- /header -->
        <!-- Header-->


        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                  <div class="col-md-12">
                      <div class="card">
                          <div class="card-header">
                              <strong class="card-title">Push Notifications</strong>
                          </div>
                          <div class="card-body">
                            <div class="default-tab">
                              <nav>
                                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                  <a class="nav-item nav-link active" id="nav-manual-selection-tab" data-toggle="tab" href="#nav-manual-selection" role="tab" aria-controls="nav-home" aria-selected="true">Manual User Selection</a>
                                  <a class="nav-item nav-link" id="nav-segment-selection-tab" data-toggle="tab" href="#nav-segment-selection" role="tab" aria-controls="nav-segment-selection" aria-selected="false">Segment User Selection</a>
                                </div>
                              </nav>
                              <div class="tab-content pl-3 pt-2" id="nav-tabContent">
                                <div class="tab-pane fade show active" id="nav-manual-selection" role="tabpanel" aria-labelledby="nav-manual-selection-tab">
                                  <div class="" id="manual_user_selection">
                                    <div class="form-group mt-full-width">
                                      <label class=" form-control-label">Users</label>
                                      <select data-placeholder="Select users to notify" multiple class="standardSelect" id="userIDs">
                                        <option value="" label="default"></option>
                                        <?php
                                          $searchCustomer = mysqli_query($db,"SELECT * FROM `users`");
                                          while ($searchCustomerRow = mysqli_fetch_array($searchCustomer)) {
                                            echo '<option value="'.$searchCustomerRow['customerToken'].'">'.$searchCustomerRow['username'].'</option>';
                                          }
                                        ?>
                                      </select>
                                    </div>
                                    <div class="form-group mt-full-width">
                                      <label class=" form-control-label">Message</label>
                                      <input type="text" class="push-msg" placeholder="Notification Message" value="">
                                    </div>
                                    <div class="form-group mt-full-width">
                                      <p class="success-msg" style="color:green;">Notification has been successful sent.</p>
                                      <button id="manual_user_selection_send" class="btn btn-outline-primary">Send Notification</button>
                                    </div>
                                  </div>
                                </div>
                                <div class="tab-pane fade" id="nav-segment-selection" role="tabpanel" aria-labelledby="nav-segment-selection-tab">
                                  <div class="" id="segment_user_selection">
                                    <div class="form-group mt-full-width">
                                      <div class="row" style="justify-content:center;margin-top:20px;margin-left: -65px;margin-right: -65px;">
                                        <div class="col-md-5">
                                          <label class="form-control-label">Search Field</label>
                                          <select name="selectSm" class="form-control-sm form-control" style="height: 40px;" id="segment_search_field">
                                            <option >Please select</option>
                                            <option value="first_name">First Name</option>
                                            <option value="last_name">Last Name</option>
                                            <option value="email">Email</option>
                                            <option value="vest_size">Vest Size</option>
                                            <option value="team_selection">Team</option>
                                            <option value="venue">Venue / Club</option>
                                            <option value="state">State</option>
                                          </select>
                                        </div>
                                        <div class="col-md-1">
                                          <label class=" form-control-label" style="color:#fff;">.</label>
                                          <div class="input-group-addon">=</div>
                                        </div>
                                        <div class="col-md-5">
                                          <div id="search_value_text">
                                            <label class="form-control-label">Search Value</label>
                                            <input style="margin: 0;" type="text"  placeholder="Search Value" value="" id="segment_search_value">
                                          </div>
                                          <div id="search_teams">
                                            <label class="form-control-label">Search Team</label>
                                            <select name="teams" class="form-control-sm form-control" style="height: 40px;" id="segment_search_team">
                                              <option >Select team</option>
                                              <?php
                                                $searchTeam = mysqli_query($db,"SELECT * FROM `team`");
                                                while ($searchTeamRow = mysqli_fetch_array($searchTeam)) {
                                                  echo '<option value="'.$searchTeamRow['token'].'">'.$searchTeamRow['teamName'].'</option>';
                                                }
                                              ?>
                                            </select>
                                          </div>
                                          <div id="search_venue">
                                            <label class="form-control-label">Search Venue / Club</label>
                                            <select name="teams" class="form-control-sm form-control" style="height: 40px;" id="segment_search_venue">
                                              <option >Select Venue/Club</option>
                                              <?php
                                                $searchVenue = mysqli_query($db,"SELECT * FROM `venues`");
                                                while ($searchVenueRow = mysqli_fetch_array($searchVenue)) {
                                                  echo '<option value="'.$searchVenueRow['token'].'">'.$searchVenueRow['name'].'</option>';
                                                }
                                              ?>
                                            </select>
                                          </div>

                                          <div id="search_state">
                                            <label class="form-control-label">Search State</label>
                                            <select name="states" class="form-control-sm form-control" style="height: 40px;" id="segment_search_state">
                                              <option value="">Select state</option>
                                              <option value="NSW">NSW</option>
                                              <option value="VIC">VIC</option>
                                              <option value="QLD">QLD</option>
                                              <option value="TAS">TAS</option>
                                              <option value="SA ">SA</option>
                                              <option value="WA">WA</option>
                                              <option value="NT">NT</option>
                                              <option value="ACT">ACT</option>
                                            </select>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row" style="justify-content:center;">
                                        <div class="col-md-6" style="margin:20px;">
                                          <button id="getSegmentUsers" class="btn btn-outline-primary">Get Users</button>
                                        </div>
                                      </div>
                                      <div id="segmentCurrentUsers">
                                        <label class=" form-control-label">Segment Users</label>
                                        <div class="" id="segmentUsers">

                                        </div>
                                      </div>

                                    </div>
                                    <div class="form-group mt-full-width">
                                      <label class=" form-control-label">Message</label>
                                      <input type="text" class="push-msg" placeholder="Notification Message" value="">
                                    </div>
                                    <div class="form-group mt-full-width">
                                      <p class="success-msg" style="color:green;">Notification has been successful sent.</p>
                                      <button id="segment_user_selection_send" class="btn btn-outline-primary">Send Notification</button>
                                    </div>
                                  </div>
                                </div>

                              </div>
                            </div>

                          </div>
                      </div>
                  </div>
                </div>
            </div><!-- .animated -->
        </div><!-- .content -->


        <div class="clearfix"></div>

        <footer class="site-footer">
            <div class="footer-inner bg-white">
                <div class="row">
                    <div class="col-sm-6">
                        Copyright &copy; <?php echo date("Y"); ?> ASRL
                    </div>
                </div>
            </div>
        </footer>

    </div><!-- /#right-panel -->

    <!-- Right Panel -->

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@2.2.4/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.4/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-match-height@0.7.2/dist/jquery.matchHeight.min.js"></script>
    <script src="assets/js/main.js"></script>


    <script src="assets/js/lib/data-table/datatables.min.js"></script>
    <script src="assets/js/lib/data-table/dataTables.bootstrap.min.js"></script>
    <script src="assets/js/lib/data-table/dataTables.buttons.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.bootstrap.min.js"></script>
    <script src="assets/js/lib/data-table/jszip.min.js"></script>
    <script src="assets/js/lib/data-table/vfs_fonts.js"></script>
    <script src="assets/js/lib/data-table/buttons.html5.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.print.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.colVis.min.js"></script>
    <script src="assets/js/init/datatables-init.js"></script>
    <script src="assets/js/lib/chosen/chosen.jquery.min.js"></script>


    <script type="text/javascript">
      $(document).ready(function() {
        $('#bootstrap-data-table-export').DataTable();

        $("[name='user_data[vest_size]']").val("<?php echo $loggedUserData['user_data']['vest_size']; ?>");
      });


      function readURL(input) {
        if (input.files && input.files[0]) {
          var reader = new FileReader();

          reader.onload = function(e) {
            $('#avatarPreview').attr('src', e.target.result);
          }

          reader.readAsDataURL(input.files[0]);
        }
      }

      $("[name='avatar']").change(function() {
        readURL(this);
      });

      jQuery(document).ready(function() {
        jQuery("#userIDs").chosen({
            disable_search_threshold: 10,
            no_results_text: "Oops, nothing found!",
            width: "100%"
        });
      });

    $("#manual_user_selection_send").click(function() {
      var userIDs = $("#userIDs").val();
      var pushMSG = $("#manual_user_selection .push-msg").val();
      console.log(userIDs);
      $.post("sendManualNotify.php",
       {
         userIDs: userIDs,
         msg: pushMSG
       },
       function(data, status){
         $("#manual_user_selection .success-msg").fadeIn();
       });
    });

    var segmentUserArray = [];

    $("#segment_user_selection_send").click(function() {
      var pushMSG = $("#segment_user_selection .push-msg").val();
      console.log(userIDs);
      $.post("sendManualNotify.php",
       {
         userIDs: segmentUserArray,
         msg: pushMSG
       },
       function(data, status){
         $("#segment_user_selection .success-msg").fadeIn();
       });
    });

    $("#getSegmentUsers").click(function() {
      var segment_search_field = $("#segment_search_field").val();
      var segment_search_value = "";
      if (segment_search_field == "team_selection") {
        segment_search_value = $("#segment_search_team").val();
      } else if (segment_search_field == "state") {
        segment_search_value = $("#segment_search_state").val();
      } else if (segment_search_field == "venue") {
        segment_search_value = $("#segment_search_venue").val();
      } else {
        segment_search_value = $("#segment_search_value").val();
      }

      $.get("returnSegmentUsers.php?segment_search_field="+segment_search_field+"&segment_search_value="+segment_search_value, function(data, status){
        segmentUserArray = [];
        var returnedUsers = JSON.parse(data);
        $("#segmentUsers").html('');
        $.each(returnedUsers, function(i, item) {
          $("#segmentUsers").append('<div class="col-md-12">'+item['username']+'</div>');
          segmentUserArray.push(item['customerToken']);
        });
        $("#segmentCurrentUsers").slideDown();
       });
    });

    $("#segment_search_field").change(function() {
      if ($(this).val() == "team_selection") {
        $("#search_value_text").slideUp();
        $("#search_state").slideUp();
        $("#search_venue").slideUp();
        $("#search_teams").slideDown();
      }else if ($(this).val() == "state") {
        $("#search_value_text").slideUp();
        $("#search_state").slideDown();
        $("#search_venue").slideUp();
        $("#search_teams").slideUp();
      }else if ($(this).val() == "venue") {
        $("#search_value_text").slideUp();
        $("#search_state").slideUp();
        $("#search_venue").slideDown();
        $("#search_teams").slideUp();
      }else {
        $("#search_value_text").slideDown();
        $("#search_state").slideUp();
        $("#search_venue").slideUp();
        $("#search_teams").slideUp();
      }
    });
  </script>


</body>
</html>
