<?php

function returnOrders($type = "normalized"){
  $output = [];
  $getOrders = ShopifyGET("/admin/api/2019-10/orders.json?limit=250&status=open",2);
  $getOrders = json_decode($getOrders,true);

  $tagSearch = $_GET['tagSearch'];
  $tagSearchArray = explode(",",$tagSearch);
  $outputJSON = [];
  foreach ($getOrders['orders'] as $value) {
    $match = false;
    $tempOutputJSON = [];
    $tags = $value['tags'];
    $tagsArray = explode(', ',$tags);
    $totalBoxLines = 0;
    foreach ($tagsArray as $value2) {
      foreach ($tagSearchArray as $tagSearchItem) {
        if ($tagSearchItem != "") {
          if ($value2 == "c-".$tagSearchItem) {
            $output['orders'][] = $value;
          }
        }
      }
    }
  }
  //$output = returnUpdatedWholesales($output);
  if ($type == "normalized") {
    $output = normalizeOrders($output);
  }
  return $output;
}

function normalizeOrders($orderJSON){
  $outputJSON = [];
  foreach ($orderJSON['orders'] as $value) {
      $tempOutputJSON = [];
        $orderNameTemp = $value['name'];
        $orderNameTemp = str_replace("#","",$orderNameTemp);

        $tempOutputJSON['id'] = $value['id'];
        $tempOutputJSON['ORDER NO.'] = $orderNameTemp;
        $tempOutputJSON['BOX NUMBER'] = $orderNameTemp;
        $tempOutputJSON['Order Name'] = $orderNameTemp;

        $tempOutputJSON['CUSTOMER NAME'] = $value['shipping_address']['first_name']." ".$value['shipping_address']['last_name'];
        $tempOutputJSON['Box Size'] = "";
        $tempOutputJSON['PHONE NUMBER'] = cleanPhone($value['shipping_address']['phone']);
        $tempOutputJSON['email'] = $value['email'];
        $tempOutputJSON['QTY'] = "1";
        if ($value['shipping_address']['company'] != "") {
          $tempOutputJSON['DELIVERY INSTRUCTIONS'] = "Company: ".$value['shipping_address']['company']." - ".$value['note_attributes'][0]['value'];
        }else {
          $tempOutputJSON['DELIVERY INSTRUCTIONS'] = $value['note_attributes'][0]['value'];
        }
        $tempOutputJSON['Shipping Company'] = $value['shipping_address']['company'];

        $tempOutputJSON['POSTAL ADDRESS'] = $value['shipping_address']['address1'];
        $tempOutputJSON['ADDRESS 2'] = $value['shipping_address']['address2'];
        $tempOutputJSON['SUBURB'] = $value['shipping_address']['city'];
        $tempOutputJSON['STATE'] = $value['shipping_address']['province'];
        $tempOutputJSON['POSTCODE'] = $value['shipping_address']['zip'];
        $tempOutputJSON['Shipping Zone'] = $value['shipping_lines'][0]['title'];

        if ($value['shipping_address']['company'] != "") {
          $tempOutputJSON['Time_window_start'] = "9:00";
          $tempOutputJSON['Time_window_end'] = "16:00";
          $tempOutputJSON['Type'] = "Business";
          $tempOutputJSON['ORDER NO.'] = $tempOutputJSON['ORDER NO.'];
        }else{
          $tempOutputJSON['Time_window_start'] = "7:00";
          $tempOutputJSON['Time_window_end'] = "18:00";
          $tempOutputJSON['Type'] = "Residential";
          $tempOutputJSON['ORDER NO.'] = $tempOutputJSON['ORDER NO.'];

          if (strpos($value['shipping_lines'][0]['title'], '12am-7am') !== false) {
            $tempOutputJSON['Time_window_start'] = "00:00";
            $tempOutputJSON['Time_window_end'] = "7:00";
          }else{
            $tempOutputJSON['Time_window_start'] = "7:00";
            $tempOutputJSON['Time_window_end'] = "18:00";
          }
        }



      $orderName = $tempOutputJSON['ORDER NO.'];

      $tempOutputJSON['(_) Boxes Made'] = "";
      $tempOutputJSON['(_) Boxes Sent Off'] = "";

      $singleFruitBox = false;
      $singleVeggieBox = false;
      $singleMixedBox = false;

      $fruitBoxCount = 0;
      $veggieBoxCount = 0;
      $mixedBoxCount = 0;

      foreach ($value['line_items'] as $lineProduct) {
        if (strpos($lineProduct['product_id'], '3965623828574') !== false) {
          $singleFruitBox = true;
          $fruitBoxCount = $lineProduct['quantity'];
        }
        if (strpos($lineProduct['product_id'], '4474336542814') !== false) {
          $singleVeggieBox = true;
          $veggieBoxCount = $lineProduct['quantity'];
        }
        if (strpos($lineProduct['product_id'], '4745766928478') !== false) {
          $singleMixedBox = true;
          $mixedBoxCount = $lineProduct['quantity'];
        }
      }

      $tempOutputJSON['VeggieBox'] = "";
      $tempOutputJSON['FruitBox'] = "";
      $tempOutputJSON['MixedBox'] = "";

      $tempOutputJSON['VeggieBoxCount'] = "";
      $tempOutputJSON['FruitBoxCount'] = "";
      $tempOutputJSON['MixedBoxCount'] = "";

      $tempOutputJSON['line_items'] = $value['line_items'];

      if ($singleFruitBox == true) {
        $tempOutputJSON['FruitBox'] = "Fruit";
        $tempOutputJSON['FruitBoxCount'] = $fruitBoxCount;
      }
      if ($singleVeggieBox == true) {
        $tempOutputJSON['VeggieBox'] = "Veggie";
        $tempOutputJSON['VeggieBoxCount'] = $veggieBoxCount;
      }
      if ($singleMixedBox == true) {
        $tempOutputJSON['MixedBox'] = "Mixed";
        $tempOutputJSON['MixedBoxCount'] = $mixedBoxCount;
      }

      $curTags = $value['tags'];
      $curTags = explode(",",$curTags);

      foreach ($curTags as $tag) {
        if (strpos($tag, 'd-') !== false) {
          $tempDate = str_replace("d-","",$tag);
          $tempDate = date("l", strtotime($tempDate));
        }
      }
      $tempOutputJSON['Delivery Day'] = $tempDate;
      $tempOutputJSON = returnBoxedRows($tempOutputJSON);
      $outputJSON = array_merge($outputJSON,$tempOutputJSON);
  }

  $outputJSON = json_encode($outputJSON);
  $outputJSON = modifyColumn($outputJSON);
  $outputJSON = appendColumn($outputJSON);
  $outputJSON = addRegion($outputJSON);

  $outputJSON = json_decode($outputJSON,true);
  return $outputJSON;
}

function returnBoxedRows($orderJSON){
/*  $boxSizes = '[{"min":"1","max":"5","boxSize":"S"},{"min":"6","max":"8","boxSize":"M"},{"min":"9","max":"16","boxSize":"L"},{"min":"17","max":"36","boxSize":"XL"}]';
  $boxSizes = json_decode($boxSizes,true);
  $boxRank = '{"XL":"1","L":"2","M":"3","S":"4","FruitBox":"5","VeggieBox":"6","MixedBox":"7"}';
  $boxRank = json_decode($boxRank,true); */
  
  
  $boxSizes = '[{"min":"1","max":"6","boxSize":"S"},{"min":"7","max":"16","boxSize":"M"},{"min":"17","max":"36","boxSize":"L"}]';
  $boxSizes = json_decode($boxSizes,true);
  $boxRank = '{"L":"2","M":"3","S":"4","FruitBox":"5","VeggieBox":"6","MixedBox":"7"}';
  $boxRank = json_decode($boxRank,true);



  $tempBoxSizes = [];

  $newJSON = [];
  $tempBoxNum = 0;

  $totalItemSizes = 0;
  foreach ($orderJSON['line_items'] as $orderItems) {
    $totalItemSizes = $totalItemSizes + (returnItemSize($orderItems['variant_id'])*$orderItems['quantity']);
  }
  $mealCount = $totalItemSizes;

  $lastBoxSize = 36;

  $XLBoxCount = $totalItemSizes/$lastBoxSize;
  $XLBoxCount = floor($XLBoxCount);

  $boxCount = ceil($totalItemSizes/$lastBoxSize);

  if ($orderJSON['VeggieBox'] != "") {
    $boxCount++;
  }
  if ($orderJSON['FruitBox'] != "") {
    $boxCount++;
  }
  if ($orderJSON['MixedBox'] != "") {
    $boxCount++;
  }


  if ($XLBoxCount >= 1) {
    $totalItemSizes = $totalItemSizes - ($XLBoxCount*$lastBoxSize);
    $tempBoxSizes['L'] = $XLBoxCount;
  }

  foreach ($boxSizes as $boxSizeTier) {
    if ($totalItemSizes >= $boxSizeTier['min'] && $totalItemSizes <= $boxSizeTier['max']) {

      if (array_key_exists($boxSizeTier['boxSize'], $tempBoxSizes)) {
      	$tempBoxSizes[$boxSizeTier['boxSize']] = $tempBoxSizes[$boxSizeTier['boxSize']]+1;
      }else{
      	$tempBoxSizes[$boxSizeTier['boxSize']] = 1;
      }
    }
  }
  //echo json_encode($tempBoxSizes);
  foreach ($tempBoxSizes as $tempKey => $tempBoxes) {

    $tempJSON = $orderJSON;

    for ($i=0; $i < $tempBoxes; $i++) {
      $tempBoxNum++;
      $tempJSON['BOX NUMBER'] = $tempJSON['ORDER NO.']."-".$tempBoxNum;
      $tempJSON['Box Size'] = $tempKey;
      $tempJSON['Box Rank'] = $boxRank[$tempKey];
      $tempJSON['Meal Count'] = $mealCount;
      $tempJSON['Box'] = "$tempBoxNum of $boxCount";
      $newJSON[] = $tempJSON;
    }
  }

  if ($orderJSON['FruitBox'] != "") {
    for ($i=0; $i < $orderJSON['FruitBoxCount']; $i++) {
      $tempBoxNum++;
      $tempJSON = $orderJSON;
      $tempJSON['BOX NUMBER'] = $tempJSON['ORDER NO.']."-".$tempBoxNum;
      $tempJSON['Box Size'] = "FruitBox";
      $tempJSON['Box Rank'] = $boxRank["FruitBox"];
      $tempJSON['Meal Count'] = $mealCount;
      $tempJSON['Box'] = "$tempBoxNum of $boxCount";
      $newJSON[] = $tempJSON;
    }
  }

  if ($orderJSON['VeggieBox'] != "") {
    for ($i=0; $i < $orderJSON['VeggieBoxCount']; $i++) {
      $tempBoxNum++;
      $tempJSON = $orderJSON;
      $tempJSON['BOX NUMBER'] = $tempJSON['ORDER NO.']."-".$tempBoxNum;
      $tempJSON['Box Size'] = "VeggieBox";
      $tempJSON['Box Rank'] = $boxRank["VeggieBox"];
      $tempJSON['Meal Count'] = $mealCount;
      $tempJSON['Box'] = "$tempBoxNum of $boxCount";
      $newJSON[] = $tempJSON;
    }
  }

  if ($orderJSON['MixedBox'] != "") {
    for ($i=0; $i < $orderJSON['MixedBoxCount']; $i++) {
      $tempBoxNum++;
      $tempJSON = $orderJSON;
      $tempJSON['BOX NUMBER'] = $tempJSON['ORDER NO.']."-".$tempBoxNum;
      $tempJSON['Box Size'] = "MixedBox";
      $tempJSON['Box Rank'] = $boxRank["MixedBox"];
      $tempJSON['Meal Count'] = $mealCount;
      $tempJSON['Box'] = "$tempBoxNum of $boxCount";
      $newJSON[] = $tempJSON;
    }
  }
  return $newJSON;
}

function returnItemSize($variantID){
  $size = 0;
	$productSize = '{"32158311317598":1,"32158311350366":1,"32158311383134":3,"32127209832542":1,"32127209865310":2,"32139244470366":1,"32139244503134":1,"32139244535902":3,"32158238408798":1,"32158238441566":1,"32158238474334":3,"32158240243806":1,"32158240276574":1,"32158240309342":3,"32158291230814":1,"32158291263582":1,"32158291296350":3,"32158322393182":1,"32158322425950":1,"32158322458718":3,"32158323572830":1,"32158323605598":2,"32158323638366":3,"32158337499230":1,"32158337531998":2,"32158337564766":3,"32167712358494":1,"32167712391262":2,"32167727956062":1,"32167727988830":2,"32167760625758":1,"32167760658526":1,"32167760691294":3,"32167770161246":1,"32167770194014":2,"29515108483166":0,"31513454313566":0,"32174493794398":0}';
	$productSize = json_decode($productSize,true);
	if (array_key_exists($variantID, $productSize)) {
		$size = $productSize[$variantID];
	}else{
		$size = 1;
	}
  return $size;
}





function addRegion($JSON){
  $JSON = json_decode($JSON, true);
  $newJSON = $JSON;

  include 'int.php';

  foreach ($JSON as $key => $value) {
    foreach ($GroupJSON as $key2 => $value2) {
      foreach ($value2['Zones'] as $key3 => $value3) {
        if ($value['Shipping Zone'] == $value3['id']) {
          $newJSON[$key]['Rank'] = $value2['rank'];
          $newJSON[$key]['Region'] = $value2['Region'];

        }
      }
    }
  }

  $sort = array();
  foreach($newJSON as $k=>$v) {
      $sort['Rank'][$k] = $v['Rank'];
      $sort['Box Rank'][$k] = $v['Box Rank'];
  }
  array_multisort($sort['Rank'], SORT_ASC, $sort['Box Rank'], SORT_ASC,$newJSON);


  $newJSON = json_encode($newJSON);
  return $newJSON;
}
function removeColumn($JSON){
  include 'dbConn.php';
  $JSON = json_decode($JSON, true);
  $newJSON = $JSON;

    foreach ($JSON as $key => $value) {
      foreach ($value as $key2 => $value2) {
        if ($key2 == "Group Name") {
          unset($newJSON[$key][$key2]);
        }
      }
    }

  $newJSON = json_encode($newJSON);
  return $newJSON;
}

function filterGroupName($JSON){
  $groupName = $_GET['groupName'];

  $JSON = json_decode($JSON, true);
  $newJSON = [];

  foreach ($JSON as $key => $value) {
    if ($value['Group Name'] == $groupName) {
      $newJSON[] = $value;
    }
  }
  $newJSON = json_encode($newJSON);
  return $newJSON;
}


function modifyColumn($JSON){
  include 'dbConn.php';
  $JSON = json_decode($JSON, true);
  $newJSON = $JSON;

  $modifyColumn = mysqli_query($db,"SELECT * FROM modifyColumn");
  while ($modifyColumn_row = mysqli_fetch_array($modifyColumn)) {
    foreach ($JSON as $key => $value) {
      foreach ($value as $key2 => $value2) {
          if ($key2 == $modifyColumn_row['columnName']) {
            if ($value2 == $modifyColumn_row['searchValue']) {
              $newJSON[$key][$key2] = $modifyColumn_row['replaceValue'];
          }
        }
      }
    }
  }

  $newJSON = json_encode($newJSON);
  return $newJSON;
}

function appendColumn($JSON){
  include 'dbConn.php';
  $JSON = json_decode($JSON, true);
  $newJSON = $JSON;

  $modifyColumn = mysqli_query($db,"SELECT * FROM appendColumn");
  while ($modifyColumn_row = mysqli_fetch_array($modifyColumn)) {
    foreach ($JSON as $key => $value) {
      foreach ($value as $key2 => $value2) {
          if ($key2 == $modifyColumn_row['columnName']) {
            if ($value2 == $modifyColumn_row['searchValue']) {
              $newJSON[$key][$modifyColumn_row['appendName']] = $modifyColumn_row['appendValue'];
          }
        }
      }
    }
  }

  $newJSON = json_encode($newJSON);
  return $newJSON;
}

function convertJSONtoCSV($JSON){

  $jsonDecoded = json_decode($JSON, true);


  $csvFileName = $_GET['tagSearch'].'-export.csv';

  $f = fopen('php://memory', 'w');
  $i = 0;
  $headers = $jsonDecoded[0];
  $headers = array_change_key_case($headers, CASE_UPPER);
  $jsonDecoded[0] = $headers;

  fputcsv($f, array_keys($jsonDecoded[0]));

  foreach ($jsonDecoded as $line) {
    fputcsv($f, $line, ",");
    $i++;
  }
  fseek($f, 0);
  header('Content-Type: application/csv');
  header('Content-Disposition: attachment; filename="'.$csvFileName.'";');
  fpassthru($f);
}
function cleanPhone($number = 0){
	$newNumber = 0;
	if (strpos($number, '+61') === 0) {
		$newNumber = str_replace("+61","61",$number);
	}elseif (strpos($number, '61') === 0) {
		$newNumber = $number;
	}elseif (strpos($number, '04') === 0) {
		$newNumber = substr($number, 1);
		$newNumber = "61".$newNumber;
	}elseif (strpos($number, '4') === 0) {
		$newNumber = "61".$number;
	}else{
		$newNumber = $number;
	}
	return preg_replace('/\s+/', '', $newNumber);
}

function removeColumnArray($JSON, $removeColumns){
  include 'dbConn.php';
  $removeColumns = explode(',',$removeColumns);
  $JSON = json_decode($JSON, true);
  $newJSON = $JSON;

    foreach ($JSON as $key => $value) {
      foreach ($value as $key2 => $value2) {
        foreach ($removeColumns as $removeTitle) {
          if (strtolower($key2) == strtolower($removeTitle)) {
            unset($newJSON[$key][$key2]);
          }
        }
      }
    }
  $newJSON = json_encode($newJSON);
  return $newJSON;
}






/* Wholesale Overide sections *START* */
$wholesale_overrides = '[{"lineitems":[{"variant_id":27550624219200,"title":"Creamy Alfredo","quantity":2,"variant_title":null,"product_id":3395455189056,"name":"Creamy Alfredo","grams":450},{"variant_id":31050876715102,"title":"Pad Thai Stirfry","quantity":2,"variant_title":null,"product_id":4326588973150,"name":"Pad Thai Stirfry","grams":380},{"variant_id":24900312956992,"title":"Afrikaan Peanut Stew","quantity":2,"variant_title":null,"product_id":2769956536384,"name":"Afrikaan Peanut Stew","grams":500},{"variant_id":31050877599838,"title":"Spicy Burrito Bowl","quantity":2,"variant_title":null,"product_id":4326589825118,"name":"Spicy Burrito Bowl","grams":450}],"id":"31400766439518"},{"lineitems":[{"variant_id":24900312956992,"title":"Afrikaan Peanut Stew","quantity":8,"variant_title":null,"product_id":2769956536384,"name":"Afrikaan Peanut Stew","grams":500}],"id":"31413575614558"},{"lineitems":[{"variant_id":27550624219200,"title":"Creamy Alfredo","quantity":8,"variant_title":null,"product_id":3395455189056,"name":"Creamy Alfredo","grams":450}],"id":"31413445787742"},{"lineitems":[{"variant_id":31050876715102,"title":"Pad Thai Stirfry","quantity":8,"variant_title":null,"product_id":4326588973150,"name":"Pad Thai Stirfry","grams":380}],"id":"31413555462238"},{"lineitems":[{"variant_id":31050877599838,"title":"Spicy Burrito Bowl","quantity":8,"variant_title":null,"product_id":4326589825118,"name":"Spicy Burrito Bowl","grams":450}],"id":"31413608611934"}]';
$wholesale_overrides = json_decode($wholesale_overrides,true);

$mealBox = '{"variant_id":29363781959744,"title":"Weekly Meal Box","quantity":1,"variant_title":"8","product_id":3063836049472,"name":"Weekly Meal Box - 8","grams":1100}';
$mealBox = json_decode($mealBox,true);

function returnUpdatedWholesales($ordersJSON){
  global $wholesale_overrides;
  global $mealBox;
  $newOrderJSON = $ordersJSON;
  foreach ($ordersJSON['orders'] as $orderKey => $order) {
    $isWholesale = false;
    foreach ($order['line_items'] as $lineKey => $lineItem) {
      $curLineQuantity = $lineItem['quantity'];
        foreach ($wholesale_overrides as $wsOverride) {
          if ($wsOverride['id'] == $lineItem['variant_id']) {
            $isWholesale = true;
            unset($newOrderJSON['orders'][$orderKey]['line_items'][$lineKey]);
            foreach ($wsOverride['lineitems'] as $newLines) {
              for ($i=0; $i < $curLineQuantity; $i++) {
                $newOrderJSON['orders'][$orderKey]['line_items'][] = $newLines;
              }
            }
            $tags = $order['tags'];
            $tagsArray = explode(', ',$tags);
            foreach ($tagsArray as $orderTag) {
              if (strpos($orderTag, 'SL:') !== false) {
                $NewShhippingLine = str_replace("SL:","",$orderTag);
                $newOrderJSON['orders'][$orderKey]['shipping_lines'][0]['title'] = $NewShhippingLine;
                $newOrderJSON['orders'][$orderKey]['shipping_lines'][0]['code'] = $NewShhippingLine;
              }
            }
          }
        }
      }
    if ($isWholesale == true) {
      $newOrderJSON['orders'][$orderKey]['line_items'][] = $mealBox;
    }
  }
  return $newOrderJSON;
}
/* Wholesale Overide sections *END* */
