<?php
  include '../dbConn.php';
  include 'checkLogin.php';
  include 'menus.php';

  $user_avatar = $loggedUserData['user_avatar'];
  $pageActive = "competition";

?>

<!doctype html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang=""> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>ASRL Portal</title>
    <meta name="description" content="Ela Admin - HTML5 Admin Template">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="https://marketappz.com/asrl/admin/images/favicon.png">
    <link rel="shortcut icon" href="https://marketappz.com/asrl/admin/images/favicon.png">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/normalize.css@8.0.0/normalize.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/lykmapipo/themify-icons@0.1.2/css/themify-icons.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/pixeden-stroke-7-icon@1.2.3/pe-icon-7-stroke/dist/pe-icon-7-stroke.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.2.0/css/flag-icon.min.css">
    <link rel="stylesheet" href="assets/css/cs-skin-elastic.css">
    <link rel="stylesheet" href="assets/css/lib/datatable/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/custom.css">

    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>

    <!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv.min.js"></script> -->

</head>
<body>
    <!-- Left Panel -->

    <aside id="left-panel" class="left-panel">
        <nav class="navbar navbar-expand-sm navbar-default">

            <div id="main-menu" class="main-menu collapse navbar-collapse">
              <?php displayMainMenu(); ?>
            </div><!-- /.navbar-collapse -->
        </nav>
    </aside><!-- /#left

    <!-- Left Panel -->

    <!-- Right Panel -->

    <div id="right-panel" class="right-panel">

        <!-- Header-->
        <header id="header" class="header">
            <div class="top-left">
                <div class="navbar-header">
                    <a class="navbar-brand" href="./"><img src="images/logo.png" alt="Logo"></a>
                    <a class="navbar-brand hidden" href="./"><img src="images/logo2.png" alt="Logo"></a>
                    <a id="menuToggle" class="menutoggle"><i class="fa fa-bars"></i></a>
                </div>
            </div>
            <div class="top-right">
                <div class="header-menu">
                    <div class="header-left">
                    </div>

                    <div class="user-area dropdown float-right">
                        <a href="#" class="dropdown-toggle active" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          <img class="user-avatar rounded-circle" src="<?php echo $user_avatar; ?>" alt="User Avatar">
                        </a>

                        <?php displayProfileMenu(); ?>

                    </div>
                </div>
            </div>
        </header><!-- /header -->
        <!-- Header-->


        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Competitions</strong>
                            </div>
                            <div class="card-body">
                                <table id="bootstrap-data-table2" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Team</th>
                                            <th>Event</th>
                                            <th>Competition Name</th>
                                            <th>Date</th>
                                            <th>Venue</th>
                                            <th>State</th>
                                            <th>Division</th>
                                            <?php
                                              $adminStatus = $_SESSION["admin"];
                                              if ($adminStatus == "y") {
                                                echo '<th>Edit</th>';
                                              }
                                            ?>

                                            <th>Results</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                      <?php
                                        $userToken = $_GET['userToken'];
                                        if ($userToken != "") {
                                          $userComps = file_get_contents('https://asrl.marketappz.com/admin/getUserComps.php?userToken='.$userToken);
                                          $userComps = json_decode($userComps,true);
                                        }
                                        $getComps = mysqli_query($db,"SELECT * FROM `competition`");
                                        while ($getCompsRow = mysqli_fetch_array($getComps)) {
                                          $dontShow = false;
                                          if ($userToken != "") {
                                            $dontShow = true;
                                            foreach ($userComps as $userCompToken) {
                                              if ($userCompToken == $getCompsRow['token']) {
                                                $dontShow = false;
                                              }
                                            }
                                          }
                                          if ($dontShow == true) {

                                          }else{
                                            $tempCompID = $getCompsRow['token'];
                                            $getTeams = mysqli_query($db,"SELECT * FROM `heats` WHERE `compToken` = '$tempCompID'");


                                            $teamArray = "";
                                            while ($getTeamsRow = mysqli_fetch_array($getTeams)) {
                                              $teamArray = $teamArray.$getTeamsRow['teamArray'];
                                            }
                                            $divisionID = $getCompsRow['divisionID'];
                                            $eventID = $getCompsRow['event'];

                                            $getDivision = mysqli_query($db,"SELECT * FROM `divisions` WHERE `token` = '$divisionID'");
                                            $getDivisionRow = mysqli_fetch_array($getDivision);

                                            $getEvent = mysqli_query($db,"SELECT * FROM `events` WHERE `token` = '$eventID'");
                                            $getEventRow = mysqli_fetch_array($getEvent);

                                            if ($adminStatus == "y") {
                                              echo '
                                                <tr>
                                                  <td>'.$teamArray.'</td>
                                                  <td>'.$getEventRow['name'].'</td>
                                                  <td>'.$getCompsRow['compName'].'</td>
                                                  <td>'.$getCompsRow['date'].'</td>
                                                  <td>'.$getCompsRow['venue'].'</td>
                                                  <td>'.$getCompsRow['state'].'</td>
                                                  <td>'.$getDivisionRow['name'].'</td>
                                                  <td><a href="createCompetitions.php?compToken='.$getCompsRow['token'].'">Edit</a></td>
                                                  <td><a href="competitionData.php?compToken='.$getCompsRow['token'].'">Results</a></td>
                                                </tr>';
                                              }else {
                                                echo '
                                                  <tr>
                                                    <td>'.$teamArray.'</td>
                                                    <td>'.$getEventRow['name'].'</td>
                                                    <td>'.$getCompsRow['compName'].'</td>
                                                    <td>'.$getCompsRow['date'].'</td>
                                                    <td>'.$getCompsRow['venue'].'</td>
                                                    <td>'.$getCompsRow['state'].'</td>
                                                    <td>'.$getDivisionRow['name'].'</td>
                                                    <td><a href="competitionData.php?compToken='.$getCompsRow['token'].'">Results</a></td>
                                                  </tr>';
                                                }
                                            }
                                          }
                                       ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->


        <div class="clearfix"></div>

        <footer class="site-footer">
            <div class="footer-inner bg-white">
                <div class="row">
                    <div class="col-sm-6">
                        Copyright &copy; <?php echo date("Y"); ?> ASRL
                    </div>
                </div>
            </div>
        </footer>

    </div><!-- /#right-panel -->

    <!-- Right Panel -->

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@2.2.4/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.4/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-match-height@0.7.2/dist/jquery.matchHeight.min.js"></script>
    <script src="assets/js/main.js"></script>


    <script src="assets/js/lib/data-table/datatables.min.js"></script>
    <script src="assets/js/lib/data-table/dataTables.bootstrap.min.js"></script>
    <script src="assets/js/lib/data-table/dataTables.buttons.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.bootstrap.min.js"></script>
    <script src="assets/js/lib/data-table/jszip.min.js"></script>
    <script src="assets/js/lib/data-table/vfs_fonts.js"></script>
    <script src="assets/js/lib/data-table/buttons.html5.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.print.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.colVis.min.js"></script>
    <script src="assets/js/init/datatables-init.js"></script>


    <script type="text/javascript">
        $(document).ready(function() {
          $('#bootstrap-data-table2').DataTable({
            "columnDefs": [
              {
                  "targets": [0],
                  "visible": false
              }
            ]
          });

          <?php if($_GET['search'] != "") : ?>
            $(".dataTables_filter").find("[type='search']").val("<?php echo $_GET['search']; ?>");
            $(".dataTables_filter").find("[type='search']").trigger('keyup');
          <?php endif; ?>
        });

      $("[data-menu-id='<?php echo $pageActive; ?>']").addClass("active");

  </script>


</body>
</html>
