<?php


function getStripeAccess($shop){

  include '/home/marketappz/public_html/gov-subscriptions/dbConn.php';
  require_once('/home/marketappz/public_html/gov-subscriptions/Stripe/stripe/init.php');

  // ADMIN STRIPE DETAILS *START*
  $shop = $shop;
  $getAppShopDetails = mysqli_query($db,"SELECT * FROM `shop_info` where shop='$shop'");
  $getAppShopDetailsRows = mysqli_fetch_array($getAppShopDetails);
  $stripe_key_type = $getAppShopDetailsRows['stripe_key_type'];

  $getAppAdminDetails = mysqli_query($db,"SELECT * FROM app_admin_settings WHERE id = '$stripe_key_type'");
  $getAppAdminDetailsRows = mysqli_fetch_array($getAppAdminDetails);
  $clientID = $getAppAdminDetailsRows['secretKey'];
  // ADMIN STRIPE DETAILS *END*


  $stripeData = mysqli_query($db,"SELECT * FROM stripe_credentials WHERE shopify_shop = '$shop'");
  $stripeData = mysqli_fetch_array($stripeData);

  $stripeAccessToken = $stripeData['access_token'];
  $stripeError = false;

  \Stripe\Stripe::setApiKey($stripeAccessToken);

  try {
    $checkAuth = \Stripe\Balance::retrieve();
    $checkAuth = json_decode($checkAuth->__toJSON(), true);
  } catch (\Stripe\Error\RateLimit $e) {
    $stripeError = true;
    // Too many requests made to the API too quickly
  } catch (\Stripe\Error\InvalidRequest $e) {
    $stripeError = true;
    // Invalid parameters were supplied to Stripe's API
  } catch (\Stripe\Error\Authentication $e) {
    $stripeError = true;
    // Authentication with Stripe's API failed
  } catch (\Stripe\Error\ApiConnection $e) {
    $stripeError = true;
    // Network communication with Stripe failed
  } catch (\Stripe\Error\Base $e) {
    $stripeError = true;
    // Display a very generic error to the user, and maybe send
  } catch (Exception $e) {
    $stripeError = true;
    // Something else happened, completely unrelated to Stripe
  }


  if ($stripeError == true) {
    $stripeRefreshToken = $stripeData['refresh_token'];

    $json = '{
     "client_secret": "'.$clientID.'",
      "grant_type": "refresh_token",
      "refresh_token": "'.$stripeRefreshToken.'"
    }';

    $json = json_decode($json, true);
    $json = json_encode($json);
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => "https://connect.stripe.com/oauth/token",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_POSTFIELDS => $json,
      CURLOPT_HTTPHEADER => array(
          "Accept: */*",
          "Cache-Control: no-cache",
          "Content-Type: application/json",
          "Host: connect.stripe.com",
          "accept-encoding: gzip, deflate",
          "cache-control: no-cache"
        ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
      //echo $response;
    }
    $response = json_decode($response, true);
    if(!isset( $response['error'] ) ){

      $access_token = $response['access_token'];
      $refresh_token = $response['refresh_token'];
      $stripe_publishable_key = $response['stripe_publishable_key'];
      $stripe_user_id = $response['stripe_user_id'];

      $updateStripeCredential = "UPDATE stripe_credentials set access_token='$access_token', refresh_token='$refresh_token', stripe_publishable_key='$stripe_publishable_key' WHERE shopify_shop = '$shop';";
      $updateStripeCredential = mysqli_query($db,$updateStripeCredential);

      return $access_token;
    }else {
      echo "Error with refreshing token: ".json_encode($response);
    }

  }else {
    return $stripeAccessToken;
  }

}
