<?php
require_once('stripe/init.php');
include '../dbConn.php';
include 'auth/accessToken.php';
include $_SERVER['DOCUMENT_ROOT'].'/gov-subscriptions/App/init.php';
include '/home/marketappz/public_html/gov-subscriptions/App/calculateDeliveryDate.php';
include '/home/marketappz/public_html/gov-subscriptions/App/notification.php';


header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header("Access-Control-Allow-Headers: X-Requested-With");
header('Content-Type: application/json');

//date_default_timezone_set('Australia/Brisbane');

$start_date = strtotime('now');

$cardToken = $_POST['stripeToken'];
$customerEmail = $_POST['email'];
$shop = $_GET['shop'];
$chargeAmount = $_POST['amount'];
$chargeAmount = $chargeAmount*100;
$billingSameAsShipping = $_POST['billingSameAsShipping'];
$NDIS_payInFull = $_POST['NDIS_payInFull'];

$customTags = "";

if ($NDIS_payInFull == "checked") {
  $customTags = $customTags."NDIS_Order,";
}
if ($_POST['oneOffPurchase'] == "yes") {
  $customTags = $customTags."OneOffPurchase,";
}

$hasNDISTag = false;
$userTags = $_POST['userTags'];
$userTags = explode(",",$userTags);
foreach ($userTags as $userTag) {
  if ($userTag == "NDIS" && $NDIS_payInFull != "checked") {
    $hasNDISTag = true;
  }
}

$subGroupID = $_POST['subGroupID'];

$chargeDay = $_POST['chargeDay'];

$subGroup = mysqli_query($db,"SELECT * FROM subscription_groups WHERE id = '$subGroupID'");
$subGroupRow = mysqli_fetch_array($subGroup);

$discountOneTime = $subGroupRow['discountOneTime'];
$skipFirstInterval = $subGroupRow['skipFirstInterval'];


$shopInfo = mysqli_query($db,"SELECT * FROM shop_info WHERE shop = '$shop'");
$shopInfoRow = mysqli_fetch_array($shopInfo);

$shopCurrency = $shopInfoRow['currency'];
$shopTaxPercentage = $shopInfoRow['taxPercentage'];

$shopTierID = $shopInfoRow['app_tier_id'];
$shopTier = mysqli_query($db,"SELECT * FROM `app_tiers` WHERE id = '$shopTierID'");
$shopTierRow = mysqli_fetch_array($shopTier);
$appTierFee = $shopTierRow['app_gateway_fee'];


$subType = $subGroupRow['subType'];
$access_token = getStripeAccess($shop);

$recurring_interval = $subGroupRow['intervalType'];

$create_Order = new order();

$order_JSON = '{
  "order": {
    "email": "'.$customerEmail.'",
    "line_items": [],
    "send_receipt": true
  }
}';

$order_JSON = json_decode($order_JSON,true);

$line_items = [];

$boxProductID = $_POST['boxProductID'];
$boxVariantID = $_POST['boxVariantID'];


$variant_id = $_POST['variantID'];
//$title = $_POST['title'];
$quantity = $_POST['quantity'];
//$product_id = $_POST['productID'];
$price = $_POST['price'];

$i = 0;

foreach ($variant_id as $value) {
  $line_items[$i]['variant_id'] = $variant_id[$i];
  $line_items[$i]['quantity'] = $quantity[$i];
  $line_items[$i]['price'] = $price[$i];
  $i++;
}


$shippingLineItem = $_POST['shippingLineItem'];
$shippingLineItem = explode('*mt-split*',$shippingLineItem);

$shipping_method = '[{"title": "'.$shippingLineItem[0].'",
  "price": "'.$shippingLineItem[1].'",
  "code": "'.$shippingLineItem[0].'",
  "source": "shopify"}]';


  //One off Purchase
  if ($_POST['oneOffPurchase'] == "yes") {
    foreach ($line_items as $lineKey => $lineItem) {
      if ($lineItem['variant_id'] == $boxVariantID) {
        $line_items[$lineKey]['price'] = ($chargeAmount/100)-$shippingLineItem[1];
      }
    }
  }
  //One off Purchase


  $order_JSON['order']['line_items'] = $line_items;



$order_JSON['order']['shipping_lines'] = json_decode($shipping_method,true);

$order_JSON['order']['buyer_accepts_marketing'] = "true";

$shippingJSON_main = $_POST['shippingJSON'];
$billingJSON_main = $_POST['billingJSON'];

$shippingJSON_main = str_replace("'", '', $shippingJSON_main);
$billingJSON_main = str_replace("'", '', $billingJSON_main);


//Calculate Tax Amount **START**
$chargeTax = true;
$boxProductJSON = ShopifyGET("/admin/api/2019-07/products/$boxProductID.json");
$boxProductJSON = json_decode($boxProductJSON,true);
foreach ($boxProductJSON['product']['variants'] as $boxJSONLine) {

  if ($boxJSONLine['id'] == $boxVariantID) {
    $chargeTax = $boxJSONLine['taxable'];
  }
}

if ($chargeTax == true) {
  $taxPercentage = $shopTaxPercentage;
  $taxChargeAmount = $chargeAmount/100;

  //Dont charge tax on Shipping $taxChargeAmount = ($chargeAmount/100)-$shippingLineItem[1];

  $orderTaxAmount = $taxChargeAmount-($taxChargeAmount*100/(100+$taxPercentage));
  $orderTaxAmount = round($orderTaxAmount, 2);
  $order_JSON['order']['taxes_included'] = "true";
  $order_JSON['order']['total_tax'] = $orderTaxAmount;
}
//Calculate Tax Amount **END**
$orderBillingAddress = "";
if ($billingSameAsShipping == "true") {
  $orderBillingAddress = $shippingJSON_main;
}else {
  $orderBillingAddress = $billingJSON_main;
}

$order_JSON['order']['billing_address'] = json_decode($orderBillingAddress,true);
$order_JSON['order']['shipping_address'] = json_decode($shippingJSON_main,true);

//Get Delivery Date *START*
$subGroupIDDeliveryDate = $subGroupID;
$shippingAddressDeliveryDate = json_decode($shippingJSON_main,true);
$postcodeDeliveryDate = $shippingAddressDeliveryDate['zip'];


$tz = 'Australia/Brisbane';
$timestamp = time();
$dt = new DateTime("now", new DateTimeZone($tz));
$dt->setTimestamp($timestamp);
$nowDateDeliveryDate = $dt->format('m/d/Y H:i');

if ($_POST['forceFree'] == "true") {
  $nowDateDeliveryDate = date("m/d/Y 14:00", strtotime($_POST['startDateForce']));
}

//echo $subGroupIDDeliveryDate.','.$postcodeDeliveryDate.','.$nowDateDeliveryDate.','."create";
$returnedDeliveryDate = returnDeliveryDate($subGroupIDDeliveryDate,$postcodeDeliveryDate,$nowDateDeliveryDate,"create");
$returnedDeliveryDate = json_decode($returnedDeliveryDate,true);
if ($_POST['forceFree'] == "true") {
  $newChargeDay = $returnedDeliveryDate['cutDate'];
  $newChargeDay = date("l", strtotime($newChargeDay));

  $chargeDay = $newChargeDay;
}

if( isset( $returnedDeliveryDate['error'] ) ){
  $deliveryDateCalculated = "";
  $cutDateCalculated = "";
}else{
  $orderNextDeliveryDate = $returnedDeliveryDate['deliveryDate'];
  $deliveryDateCalculated = 'd-'.$returnedDeliveryDate['deliveryDate'];
  $cutDateCalculated = 'c-'.$returnedDeliveryDate['cutDate'];
}
//Get Delivery Date *END*


$orderNotes = $_POST['orderNotes'];
$orderNotes = preg_replace('/[^(\x20-\x7F)]*/','', $orderNotes);
$orderNotes = preg_replace("/[^a-zA-Z0-9 ]+/", "", $orderNotes);

$note_attributes = [];
$note_attributes[0] = json_decode('{"name":"Delivery Notes","value":"'.$orderNotes.'"}',true);
$note_attributes[1] = json_decode('{"name":"Order Count","value":"1"}',true);
$order_JSON['order']['note_attributes'] = $note_attributes;



if ($hasNDISTag == true) {
  $order_JSON['order']['tags'] = "FirstRecurringOrder, RecurringOrder, NDIS_Order, NDIS_Pending".", ".$customTags;
}else {
  $order_JSON['order']['tags'] = "FirstRecurringOrder, RecurringOrder,".$deliveryDateCalculated.','.$cutDateCalculated.", ".$customTags;
}

$customerName = json_decode($shippingJSON_main,true);
$customerName = $customerName['first_name']." ".$customerName['last_name'];

$gatwayJSON1 = '["stripe"]';
$order_JSON['order']['payment_gateway_names'] = json_decode($gatwayJSON1,true);
$order_JSON['order']['gateway'] = 'stripe';

$transactionAmount = $chargeAmount/100;

if ($transactionAmount > 0 ) {
  $transactionsJSON = '[{"currency": "'.$shopCurrency.'","amount": "'.$transactionAmount.'","kind": "sale"}]';
  $order_JSON['order']['transactions'] = json_decode($transactionsJSON,true);
}

if ($hasNDISTag == true) {
  $order_JSON['order']['financial_status'] = "paid";
}


$discount = '[{"code": "'.$_POST['discountCode'].'",
                "amount": "'.$_POST['discountVal'].'",
                "type": "'.$_POST['discountType'].'"}]';
$order_JSON['order']['discount_codes'] = json_decode($discount,true);

$order_JSON = json_encode($order_JSON);

$error = false;

\Stripe\Stripe::setApiKey($access_token);

if ($_POST['forceFree'] == "true") {
  // code...
}else{

  try {
    $createCustomer = \Stripe\Customer::create([
      "description" => "Customer for $customerEmail",
      "source" => "$cardToken",
      "email" => "$customerEmail"
    ]);
  }catch(\Stripe\Error\Card $e) {
    $body = $e->getJsonBody();
    $err  = $body['error'];
    errorRedirect($err['message']);
    $error = true;
  } catch (\Stripe\Error\RateLimit $e) {
      errorRedirect("Too many requests made to the API too quickly");
      $error = true;
  } catch (\Stripe\Error\InvalidRequest $e) {
      errorRedirect("Invalid parameters were supplied to Stripe's API");
      $error = true;
  } catch (\Stripe\Error\Authentication $e) {
      errorRedirect("Authentication with Stripe's API failed");
    $error = true;
  } catch (\Stripe\Error\ApiConnection $e) {
      errorRedirect("Network communication with Stripe failed");
      $error = true;
  } catch (\Stripe\Error\Base $e) {
      errorRedirect("An error has occurred. Please try again.");
      $error = true;
  } catch (Exception $e) {
      errorRedirect("An error has occurred. Please try again.");
      $error = true;
  }
}



if ($chargeAmount > 0 && $error == false) {
  $createCustomer = json_decode($createCustomer->__toJSON(), true);
  $customerID = $createCustomer['id'];
  $appFeeCharge = $chargeAmount*($appTierFee/100);
  $appFeeCharge = round($appFeeCharge);

  try {
    $chargeCustomer = \Stripe\Charge::create([
      "amount" => $chargeAmount,
      "currency" => $shopCurrency,
      "customer" => "$customerID",
      "application_fee_amount" => $appFeeCharge,
      "description" => "$shop",
      "capture" => "false"
    ]);
    $chargeCustomer = json_decode($chargeCustomer->__toJSON(), true);
    $stripeTransID = $chargeCustomer['id'];
  }catch(\Stripe\Error\Card $e) {
    $body = $e->getJsonBody();
    $err  = $body['error'];

    //print('Status is:' . $e->getHttpStatus() . "\n");
    //print('Type is:' . $err['type'] . "\n");
    //print('Code is:' . $err['code'] . "\n");
    // param is '' in this case
    //print('Param is:' . $err['param'] . "\n");
    //print('Message is:' . $err['message'] . "\n");

    errorRedirect($err['message']);
    $error = true;

  } catch (\Stripe\Error\RateLimit $e) {
    // Too many requests made to the API too quickly
      errorRedirect("Too many requests made to the API too quickly");
      $error = true;
  } catch (\Stripe\Error\InvalidRequest $e) {
    // Invalid parameters were supplied to Stripe's API
      errorRedirect("Invalid parameters were supplied to Stripe's API");
      $error = true;
  } catch (\Stripe\Error\Authentication $e) {
    // Authentication with Stripe's API failed
    errorRedirect("Authentication with Stripe's API failed");
    $error = true;
  } catch (\Stripe\Error\ApiConnection $e) {
    // Network communication with Stripe failed
      errorRedirect("Network communication with Stripe failed");
      $error = true;
  } catch (\Stripe\Error\Base $e) {
    // Display a very generic error to the user, and maybe send
      errorRedirect("An error has occurred. Please try again.");
      $error = true;
    // yourself an email
  } catch (Exception $e) {
    // Something else happened, completely unrelated to Stripe
      errorRedirect("An error has occurred. Please try again.");
      $error = true;
  }
}
if ($error == false) {
  $orderJSON = ShopifyPOST("/admin/api/2019-04/orders.json",$order_JSON);

  $orderJSON = json_decode($orderJSON,true);

  if (!isset($orderJSON['errors'])) {
    if ($chargeAmount > 0) {
      $charge = \Stripe\Charge::retrieve($stripeTransID);
      $charge->capture();
    }

    $shopifyCustomerID = $orderJSON['order']['customer']['id'];
    $orderConfirmationUrl = $orderJSON['order']['order_status_url'];

    $orderName = $orderJSON['order']['name'];


    $orderID = $orderJSON['order']['id'];

    if ($_POST['forceFree'] == "true") {
      $start_date = strtotime($_POST['startDateForce']);

      $nextChargeDate = calculateNextChargeDate($subGroupID,$start_date,$chargeDay);
    }else{
      $nextChargeDate = calculateNextChargeDate($subGroupID,$start_date,$chargeDay);
    }

    $subscriptionToken = generateToken();

    $lastOrderID = $orderID;

    $NDIS_status = 'n';

    if ($_POST['oneOffPurchase'] != "yes") {
      if ($hasNDISTag != true) {
        $sql = "INSERT INTO subscription (subscriptionToken,shop, stripe_customer_id, shopify_customer_id, customer_email, subscriptionGroupsID,start_date, recurring_interval,nextChargeDate,chargeAmount,chargeDay,customerName,lastOrderID,NDIS_status,custom_tags) VALUES ('$subscriptionToken','$shop', '$customerID', '$shopifyCustomerID', '$customerEmail','$subGroupID','$start_date', '$recurring_interval','$nextChargeDate','$chargeAmount','$chargeDay','$customerName','$lastOrderID','$NDIS_status','$customTags')";
        $charge_insert = mysqli_query($db,$sql);

        //if ($NDIS_payInFull == "checked") {
          $saveNDISOrder = mysqli_query($db,"INSERT INTO `NDIS_orders` (`orderID`, `subGroup_ID`,`subscriptionToken`,`status`,`shop`) VALUES ('$lastOrderID', '$subGroupID','$subscriptionToken','complete','$shop');");
        //}
      }else{
        $NDIS_status = "y";
        //$sql = "INSERT INTO subscription (subscriptionToken,shop, stripe_customer_id, shopify_customer_id, customer_email, subscriptionGroupsID,start_date, recurring_interval,nextChargeDate,chargeAmount,chargeDay,customerName,lastOrderID,NDIS_status) VALUES ('$subscriptionToken','$shop', '$customerID', '$shopifyCustomerID', '$customerEmail','$subGroupID','$start_date', '$recurring_interval','$nextChargeDate','$chargeAmount','$chargeDay','$customerName','$lastOrderID','$NDIS_status')";
        //$charge_insert = mysqli_query($db,$sql);
        $saveNDISOrder = mysqli_query($db,"INSERT INTO `NDIS_orders` (`orderID`, `subGroup_ID`,`subscriptionToken`,`shop`) VALUES ('$lastOrderID', '$subGroupID','$subscriptionToken','$shop');");
      }
    }


    $orderSaveBillingAddress = "";
    if ($billingSameAsShipping == "true") {
      $orderSaveBillingAddress = $shippingJSON_main;
    }else {
      $orderSaveBillingAddress = $billingJSON_main;
    }

    $shippingJSON = json_encode(json_decode($shippingJSON_main,true));
    $billingJSON = json_encode(json_decode($orderSaveBillingAddress,true));
    $productJSON = json_encode($line_items);

    if ($discountOneTime == "yes") {
      $discount = '[{"code":"","amount":"","type":""}]';
    }

    $discount = json_encode(json_decode($discount,true));
    $shipping_method = json_encode(json_decode($shipping_method,true));

    $addSubExtraSQL = "INSERT INTO subscription_extra (subscriptionToken, shipping_JSON, billing_JSON, product_JSON, shippingMethod_JSON, discount_JSON,order_notes,boxProductID,boxVariantID) VALUES ('$subscriptionToken','$shippingJSON', '$billingJSON', '$productJSON','$shipping_method','$discount','$orderNotes','$boxProductID','$boxVariantID')";
    $addSubExtra = mysqli_query($db,$addSubExtraSQL);


    $futureProductJSON = [];
    for ($i=0; $i < 6; $i++) {
      $tempProdJSON = [];
      $tempProdJSON['orderProducts'] = json_decode($productJSON,true);
      if ($skipFirstInterval == "yes" && $i == 0) {
        $tempProdJSON['skipOrder'] = 'true';
      }else{
        $tempProdJSON['skipOrder'] = 'false';
      }
      $futureProductJSON[] = $tempProdJSON;
    }

    $futureProductJSON = json_encode($futureProductJSON);

    $addSubFutureOrdersSQL = "INSERT INTO subscription_future_orders (subscriptionID, subscriptionJSON) VALUES ('$subscriptionToken','$futureProductJSON')";
    $addSubFutureOrdersSQL = mysqli_query($db,$addSubFutureOrdersSQL);

    $addSubLog = "INSERT INTO subscription_log (shop, timestamp, status) VALUES ('$shop','$start_date', 'subscribed')";
    $addSubLog = mysqli_query($db,$addSubLog);

    $responseMSG = '
    {
      "Error": false,
      "redirectURL": "'.$orderConfirmationUrl.'",
      "orderName": "'.$orderName.'"
    }
    ';

    $responseMSG = json_decode($responseMSG,true);
    echo $responseMSG = json_encode($responseMSG);

    $logChargeAmount = $chargeAmount/100;
    $logStripeID = $stripeTransID;
    $logNotes = "Initial Subscription Created: https://$shop/admin/orders/".$orderID;
    logRecharge($shop, $shopifyCustomerID, $subscriptionToken, "Success", $logNotes, $logChargeAmount,$customerEmail,$customerName,$subscriptionToken,$orderID,$logStripeID);



    if ($hasNDISTag == true && $NDIS_payInFull != "checked") {

    }else {
      if ($_POST['oneOffPurchase'] != "yes") {
        notify($shop,$subscriptionToken,"orderConfirmationCustomer","no",$orderNextDeliveryDate);
      }else{
        notify($shop,$subscriptionToken,"orderConfirmationCustomer","no",$orderNextDeliveryDate,$customerEmail);
      }
    }

  }


}


function calculateNextChargeDate($subscriptionGroupID,$startDate,$chargeDate){
  include '../dbConn.php';

  $getSubGroup = mysqli_query($db,"SELECT * FROM subscription_groups WHERE id = '$subscriptionGroupID'");
  $getSubGroupRow = mysqli_fetch_array($getSubGroup);

  $dt = new DateTime('@'.$startDate);
  $dt->setTimeZone(new DateTimeZone('Australia/Brisbane'));
  $startDate = $dt->format('Y-m-d');
  $startDate = strtotime($startDate);

  $curTime = new DateTime();
  $curTime->setTimeZone(new DateTimeZone('Australia/Brisbane'));
  $curTime = $curTime->format('H:i');
  $cutoffTime = $getSubGroupRow['cutoff'];
  //$curTime = strtotime($curTime);




  if ($getSubGroupRow['intervalType'] == "week") {
    if ($getSubGroupRow['chargeDate'] == "purchaseDate") {
      $startDate = new DateTime(gmdate("Y-m-d", $startDate));
      $startDate = $startDate->format('Y-m-d');
      $intervalCharge = $getSubGroupRow['intervalCharge'];

      $nextChargeDate = new DateTime($startDate);
      $nextChargeDate = $nextChargeDate->modify('+'.$intervalCharge.' week');
      $nextChargeDate = $nextChargeDate->format('d-m-Y');

      return $nextChargeDate;
    }else{
      $startDate = new DateTime(gmdate("Y-m-d", $startDate));
      $startDate = $startDate->format('Y-m-d');
      $intervalCharge = $getSubGroupRow['intervalCharge'];

      if ($getSubGroupRow['bufferDays'] == 0) {
        $startDatePlusBuffer = $startDate;
      }else {
        $startDatePlusBuffer = date('Y-m-d', strtotime($startDate. ' + '.$getSubGroupRow['bufferDays'] .' days'));

      }
      $tempDay = date('l', strtotime($startDatePlusBuffer));
      if ($tempDay == $chargeDate && $curTime < $cutoffTime) {
        $nextChargeDate = new DateTime($startDatePlusBuffer);
        $nextChargeDate = $nextChargeDate->format('d-m-Y');
        return $nextChargeDate;
      }else{
        $nextChargeDate = new DateTime($startDatePlusBuffer);
        $intervalCharge = $intervalCharge-1;
        $nextChargeDate = $nextChargeDate->modify('next '.$chargeDate."+ $intervalCharge week");
        $nextChargeDate = $nextChargeDate->format('d-m-Y');

        return $nextChargeDate;
      }
    }
  }else if($getSubGroupRow['intervalType'] == "month"){
    $startDate = new DateTime(gmdate("Y-m-d", $startDate));
    $startDate = $startDate->format('Y-m-d');
    $intervalCharge = $getSubGroupRow['intervalCharge'];

    $nextChargeDate = new DateTime($startDate);
    $nextChargeDate = $nextChargeDate->modify('+'.$intervalCharge.' months');
    $nextChargeDate = $nextChargeDate->format('d-m-Y');

    return $nextChargeDate;
  }else if($getSubGroupRow['intervalType'] == "year"){
    $startDate = new DateTime(gmdate("Y-m-d", $startDate));
    $startDate = $startDate->format('Y-m-d');
    $intervalCharge = $getSubGroupRow['intervalCharge'];

    $nextChargeDate = new DateTime($startDate);
    $nextChargeDate = $nextChargeDate->modify('+'.$intervalCharge.' year');
    $nextChargeDate = $nextChargeDate->format('d-m-Y');

    return $nextChargeDate;
  }else if($getSubGroupRow['intervalType'] == "day"){
    $startDate = new DateTime(gmdate("Y-m-d", $startDate));
    $startDate = $startDate->format('Y-m-d');
    $intervalCharge = $getSubGroupRow['intervalCharge'];

    $nextChargeDate = new DateTime($startDate);
    $nextChargeDate = $nextChargeDate->modify('+'.$intervalCharge.' day');
    $nextChargeDate = $nextChargeDate->format('d-m-Y');

    return $nextChargeDate;
  }
}

function generateToken() {
    include '../dbConn.php';
    $randomString = generateRandomString();

    $checkValid = mysqli_query($db,"SELECT * FROM `subscription_future_orders` WHERE `subscriptionID` = '$randomString'");
    $checkValid = mysqli_num_rows($checkValid);

    if ($checkValid == 0) {
      return $randomString;
    }else{
      $newString = generateRandomString();
      $randomString = $randomString.$newString;
      return $randomString;
    }


}


function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

function errorRedirect($error){
  $responseMSG = '
  {
    "Error": true,
    "errorMSG": "'.$error.'"
  }
  ';
  $responseMSG = json_decode($responseMSG,true);
  echo $responseMSG = json_encode($responseMSG);

}


function logRecharge($shopify_shop, $shopify_customer_id, $subscription_id, $status, $notes, $amount,$Email,$customerName,$subID,$logOrderID,$logStripeID){
  include '../dbConn.php';

  $unix_date = strtotime("now");

  $sqlLog = "INSERT INTO `recharge_log`(`shopify_shop`, `shopify_customer_id`, `status`,`notes`,`customerName`,`amount`,`customerEmail`,`date`,`subscriptionToken`,`logOrderID`,`logStripeID`) VALUES ('$shopify_shop', '$shopify_customer_id', '$status','$notes','$customerName','$amount','$Email','$unix_date','$subID','$logOrderID','$logStripeID')";
  $sqlLogRow = mysqli_query($db,$sqlLog);
}
