<?php
$time_start = microtime(true); 
include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/dbConn.php';
include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/Shopify/requestNoQuery.php';

include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/app/admin/currency_convertor.php';

$dontFormat = '["total_products","compare_total_products","compare_percentage_total_products","total_orders","gross_margin","net_margin","compare_total_orders","compare_percentage_total_orders","compare_total_refunds","compare_percentage_total_refunds","compare_percentage_total_paid","compare_percentage_shipping_charged","compare_percentage_shipping_cost","compare_percentage_total_tax","compare_percentage_total_discounts","compare_percentage_total_COGS","compare_percentage_transaction_fees","compare_percentage_gross_profit","compare_gross_margin","compare_percentage_gross_margin","compare_percentage_avg_order_value","compare_percentage_avg_order_profit","compare_percentage_total_ad_spend","compare_percentage_per_order_ad_spend","compare_percentage_net_profit","compare_net_margin","compare_percentage_net_margin"]';

$shop = $_GET['shop'];
$startDate = $_GET['startDate'];
$endDate = $_GET['endDate'];

$getStoreData = mysqli_query($db,"SELECT * FROM `shopify_credentials` WHERE `shopify_shop`='$shop'");
$getStoreDataRow = mysqli_fetch_array($getStoreData);

$curDateRange = file_get_contents('https://marketappz.com/metric-kings/app/admin/returnMetricData.php?startDate='.$startDate.'&endDate='.$endDate.'&shop='.$shop);
$curDateRange = json_decode($curDateRange,true);

$compareStart = strtotime($startDate);
$compareEnd = strtotime($endDate);
$datediff = $compareStart - $compareEnd;
$compareDays = round($datediff / (60 * 60 * 24));
$compareDays = abs($compareDays)+1;

$compareStartDate = strtotime($startDate." -$compareDays days");
$compareStartDate = gmdate("d-m-Y", $compareStartDate);
$compareEndDate = strtotime($startDate." -1 days");
$compareEndDate = gmdate("d-m-Y", $compareEndDate);
$compareDateRange = file_get_contents('https://marketappz.com/metric-kings/app/admin/returnMetricData.php?startDate='.$compareStartDate.'&endDate='.$compareEndDate.'&shop='.$shop);
$compareDateRange = json_decode($compareDateRange,true);



$data = array(
  'https://marketappz.com/metric-kings/app/admin/returnMetricData.php?startDate='.$startDate.'&endDate='.$endDate.'&shop='.$shop,
  'https://marketappz.com/metric-kings/app/admin/returnMetricData.php?startDate='.$compareStartDate.'&endDate='.$compareEndDate.'&shop='.$shop
);
$multi_request = multiRequest($data);
$curDateRange = $multi_request[0];
$compareDateRange = $multi_request[1];


$outputJSON = [];

foreach ($curDateRange as $curKey => $curValue) {
  foreach ($compareDateRange as $compareKey => $compareValue) {
    if ($curKey == $compareKey) {
      $tempJSON = [];
      $tempJSON[$curKey] = $curValue;
      $tempJSON["compare_".$curKey] = $compareValue;
      if ($curValue > 0 && $compareValue > 0) {
        $tempJSON["compare_percentage_".$curKey] = round(percentDiff($curValue,$compareValue));
      }else{
        $tempJSON["compare_percentage_".$curKey] = 0;
      }

      $outputJSON[] = $tempJSON;
    }
  }
}


$dontFormat = json_decode($dontFormat,true);
$tempOutput = $outputJSON;
$outputJSON = [];
foreach ($tempOutput as $value) {
  foreach ($value as $key => $value2) {
    $outputJSON[$key] = $value2;
  }
}

foreach ($outputJSON as $key => $value) {
  $convert = true;
  foreach ($dontFormat as $dontFormatKey) {
    if ($key == $dontFormatKey) {
      $convert = false;
    }
  }

  if ($convert == true) {
    $outputJSON[$key] = returnMoneyFormat($value);
  }else{
    $outputJSON[$key] = $value;
  }
}

echo json_encode($outputJSON);


function percentDiff($recent,$previous){
  $result=(($recent-$previous)/$previous);
  $output = ($result*100);
  return $output;
}


function multiRequest($data, $options = array()) {

  // array of curl handles
  $curly = array();
  // data to be returned
  $result = array();

  // multi handle
  $mh = curl_multi_init();

  // loop through $data and create curl handles
  // then add them to the multi-handle
  foreach ($data as $id => $d) {

    $curly[$id] = curl_init();

    $url = (is_array($d) && !empty($d['url'])) ? $d['url'] : $d;
    curl_setopt($curly[$id], CURLOPT_URL,            $url);
    curl_setopt($curly[$id], CURLOPT_HEADER,         0);
    curl_setopt($curly[$id], CURLOPT_RETURNTRANSFER, 1);

    // post?
    if (is_array($d)) {
      if (!empty($d['post'])) {
        curl_setopt($curly[$id], CURLOPT_POST,       1);
        curl_setopt($curly[$id], CURLOPT_POSTFIELDS, $d['post']);
      }
    }

    // extra options?
    if (!empty($options)) {
      curl_setopt_array($curly[$id], $options);
    }

    curl_multi_add_handle($mh, $curly[$id]);
  }

  // execute the handles
  $running = null;
  do {
    curl_multi_exec($mh, $running);
  } while($running > 0);


  // get content and remove handles
  foreach($curly as $id => $c) {
    $result[$id] = json_decode(curl_multi_getcontent($c),true);
    curl_multi_remove_handle($mh, $c);
  }

  // all done
  curl_multi_close($mh);

  return $result;
}




// Anywhere else in the script
echo 'Total execution time in seconds: ' . (microtime(true) - $time_start);

?>
