<?php
ini_set("allow_url_fopen", 1);

include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/dbConn.php';
include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/app/admin/currency_convertor.php';

$shop = $_GET['shop'];
$itemID = $_GET['itemID'];

date_default_timezone_set($shop_timezone);

$startDate = $_GET['startDate'];
$endDate = $_GET['endDate'];

$displayType = "";

// Days Between Calculate *START*
$daysBetweenStart = strtotime($startDate);
$daysBetweenEnd = strtotime($endDate);
$datediff = $daysBetweenStart - $daysBetweenEnd;
$daysBetween = abs(round($datediff / (60 * 60 * 24)));
// Days Between Calculate *END*

if ($daysBetween > 60) {
  $start = (new DateTime($startDate))->modify('first day of this month');
  $end = (new DateTime($endDate))->modify('first day of next month');
  $interval = DateInterval::createFromDateString('1 month');
  $dateArray = new DatePeriod($start, $interval, $end);
  $displayType = "month";
}else{
  $period = new DatePeriod(
       new DateTime($startDate),
       new DateInterval('P1D'),
       new DateTime($endDate)
  );
  $dateArray = [];
  $dateArray[] = $startDate;

  foreach ($period as $key => $value) {
      $dateArray[] = $value->format('d-m-Y');
  }

  $dateArray[] = $endDate;

  $displayType = "day";
}



$outputData = [];

$dateData = [];

foreach ($dateArray as $curDate) {
  if ($displayType == "month") {
    $startDate = $curDate->format("01-m-Y");
    $endDate = $curDate->format("t-m-Y");
    $displayLabel = $curDate->format("F Y");
  }else{
    $startDate = $curDate;
    $endDate = $curDate;
    $displayLabel = $curDate;
  }


  $getMetricData = file_get_contents('https://marketappz.com/metric-kings/app/admin/returnMetricData.php?token=gCB0AJTcrF&startDate='.$startDate.'&endDate='.$endDate.'&shop='.$shop.'&limitReturn='.$itemID);
  $getMetricData = json_decode($getMetricData,true);
  $curValue = returnMoneyFormat($getMetricData[$itemID],false,true);
  $curValue = number_format((float)$curValue, 2, '.', '');

  $dateData[$displayLabel] = $curValue;
}

$outputData[$itemID] = $dateData;

echo json_encode($outputData);
?>
