<?php
ini_set("allow_url_fopen", 1);

include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/dbConn.php';
include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/Shopify/requestNoQuery.php';
include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/app/admin/currency_convertor.php';

$time_start = microtime(true);

$shop = $_GET['shop'];
$limitReturn = $_GET['limitReturn'];

$dontLoadFB = false;
$dontLoaGA = false;

if ($limitReturn != "total_ad_spend" && $limitReturn != "per_order_ad_spend" && $limitReturn != "net_margin" && $limitReturn != "net_profit") {
  if ($limitReturn != "") {
    $dontLoadFB = true;
    $dontLoaGA = true;
  }
}

$getStoreData = mysqli_query($db,"SELECT * FROM `shopify_credentials` WHERE `shopify_shop`='$shop'");
$getStoreDataRow = mysqli_fetch_array($getStoreData);

$storeCurrency = $getStoreDataRow['store_currency'];
$displayCurrency = $getStoreDataRow["display_currency"];

$shop_timezone = $getStoreDataRow["shop_timezone"];

date_default_timezone_set($shop_timezone);

$startDateFinal = $_GET['startDate'];
$endDateFinal = $_GET['endDate'];

$startDate = $_GET['startDate'];
$endDate = $_GET['endDate'];

$startDate = $startDate." 00:00:00";
$endDate = $endDate." 23:59:59";

$startDate = strtotime($startDate);
$endDate = strtotime($endDate);


$outputJSON = [];

$default_shipping_cost = null;
$globalOrdersShippingCost = null;

$getOrders = mysqli_query($db,"SELECT * FROM `order_data` WHERE (order_date BETWEEN '$startDate' AND '$endDate') AND `shop`='$shop'");

$total_paid = 0;
$shipping_charged = 0;
$total_tax = 0;
$total_discounts = 0;
$total_COGS = 0;

$gross_profit = 0;
$gross_margin = 0;

$transaction_fees = 0;
$shipping_cost = 0;

$avg_order_value = 0;
$avg_order_profit = 0;

$total_ad_spend = 0;

$avg_order_COGS = 0;


$fb_ad_status = $getStoreDataRow['fb_ad_status'];
if ($fb_ad_status == "active" && $dontLoadFB == false) {
  $getFBAdSpend = file_get_contents('https://marketappz.com/metric-kings/facebook-ads/returnAdSpend.php?shop='.$shop.'&startDate='.$startDateFinal.'&endDate='.$endDateFinal);
  $getFBAdSpend = json_decode($getFBAdSpend,true);
  $fbAdSpend = $getFBAdSpend['total_ad_spend'];
}else{
  $fbAdSpend = 0;
}

$ga_ad_status = $getStoreDataRow["ga_ad_status"];
if ($ga_ad_status == "active" && $dontLoaGA == false) {
  $getGAAdSpend = file_get_contents('https://marketappz.com/metric-kings/google-ads/returnAdSpend.php?shop='.$shop.'&startDate='.$startDateFinal.'&endDate='.$endDateFinal);
  $getGAAdSpend = json_decode($getGAAdSpend,true);
  $gaAdSpend = $getGAAdSpend['total_ad_spend'];
}else{
  $gaAdSpend = 0;
}

$total_ad_spend = $fbAdSpend+$gaAdSpend;

$total_ad_spend_store_currency = currencyConverter($displayCurrency,$storeCurrency,$total_ad_spend);

$total_refunds = 0;

$total_products = 0;

$total_orders = mysqli_num_rows($getOrders);
$outputJSON['total_orders'] = $total_orders;

//echo 'Before Calculations: ' . (microtime(true) - $time_start);

while ($getOrdersRow = mysqli_fetch_array($getOrders)) {
  $tempOrderID = $getOrdersRow['orderID'];

  $total_paid = $total_paid+$getOrdersRow['total_paid'];
  $shipping_charged = $shipping_charged+(float)$getOrdersRow['shipping_charged'];
  $total_tax = $total_tax+$getOrdersRow['total_tax'];
  $total_discounts = $total_discounts+$getOrdersRow['total_discounts'];

  // Calculate COGS *START*
  /*$getOrdersItems = mysqli_query($db,"SELECT * FROM `order_line_items` WHERE `orderID`='$tempOrderID' AND `shop`='$shop'");
  while ($getOrdersItemsRow = mysqli_fetch_array($getOrdersItems)) {
    $total_COGS = $total_COGS+($getOrdersItemsRow['product_cost']*$getOrdersItemsRow['quantity']);
    $total_products = $total_products+$getOrdersItemsRow['quantity'];
  }*/

  $total_COGS = $total_COGS+$getOrdersRow['orderTotalCOGS'];
  $total_products = $total_products+$getOrdersRow['orderTotalProducts'];
  // Calculate COGS *END*

  // Calculate Shipping Cost *START* MAKE FUNCTION
  $shipping_cost = $shipping_cost+returnShippingCost($tempOrderID,$shop,$getOrdersRow['shipping_data']);
  // Calculate Shipping Cost *END*

  $transaction_fees = $transaction_fees+returnTransactionFee($tempOrderID,$shop,$getOrdersRow['total_paid'],$getOrdersRow['gateway']);
}
//echo 'After Calculations: ' . (microtime(true) - $time_start);

$get_refund_data = mysqli_query($db,"SELECT * FROM `refund_data` WHERE (refund_date BETWEEN '$startDate' AND '$endDate') AND `shop`='$shop'");
while ($get_refund_dataRow = mysqli_fetch_array($get_refund_data)) {
  $total_refunds = $total_refunds+$get_refund_dataRow['refund_amount'];
}

$outputJSON['total_products'] = $total_products;
$total_sale_amount = $total_paid;

$total_paid = $total_paid-$total_refunds;

$outputJSON['total_refunds'] = $total_refunds;

$outputJSON['total_paid'] = $total_paid;
$outputJSON['shipping_charged'] = $shipping_charged;
$outputJSON['shipping_cost'] = $shipping_cost;

$outputJSON['total_tax'] = $total_tax;
$outputJSON['total_discounts'] = $total_discounts;
$outputJSON['total_COGS'] = $total_COGS;

$outputJSON['transaction_fees'] = $transaction_fees;

$total_expenses = $transaction_fees+$total_COGS+$shipping_cost;
$outputJSON['total_expenses'] = $total_expenses;


$gross_profit = $total_paid-$total_tax-$total_COGS-$transaction_fees-$shipping_cost;
$outputJSON['gross_profit'] = $gross_profit;

$gross_margin = returnPercentage($gross_profit,$total_paid);

$outputJSON['gross_margin'] = $gross_margin."%";

$avg_order_value = returnAverage($total_sale_amount,$total_orders);

$outputJSON['avg_order_value'] = $avg_order_value;

$avg_order_profit = returnAverage($gross_profit,$total_orders);

$outputJSON['avg_order_profit'] = $avg_order_profit;

$outputJSON['total_ad_spend'] = $total_ad_spend;

$per_order_ad_spend = returnAverage($total_ad_spend_store_currency,$total_orders);

$outputJSON['per_order_ad_spend'] = $per_order_ad_spend;

$avg_order_COGS = returnAverage($total_COGS,$total_orders);
$outputJSON['avg_order_COGS'] = $avg_order_COGS;

$avg_order_expenses = returnAverage($total_expenses,$total_orders);

//$break_even_ROAS = ($avg_order_value - $avg_order_expenses)/$avg_order_expenses;
//$break_even_ROAS = number_format((float)$break_even_ROAS, 2, '.', '');

if ($gross_margin > 0) {
  $break_even_ROAS = (1/($gross_margin/100));
  $break_even_ROAS = number_format((float)$break_even_ROAS, 2, '.', '');
}else{
  $break_even_ROAS = 0;
}
$outputJSON['break_even_ROAS'] = $break_even_ROAS;


$net_profit = $gross_profit-$total_ad_spend_store_currency;
$outputJSON['net_profit'] = $net_profit;

$net_margin = returnPercentage($net_profit,$total_paid);

$outputJSON['net_margin'] = $net_margin."%";

//echo 'END Calculations: ' . (microtime(true) - $time_start);
//echo "<br>";

echo json_encode($outputJSON);

function returnShippingCost($orderID,$shop,$shipping_data){
  global $db;
  global $default_shipping_cost;
  global $globalOrdersShippingCost;
  $outputShippingCost = 0;

  if ($default_shipping_cost == null) {
    $getDefaultCost = mysqli_query($db,"SELECT * FROM `default_shipping_cost` WHERE `shop`='$shop'");
    $getDefaultCostRow = mysqli_fetch_array($getDefaultCost);
    $default_cost = $getDefaultCostRow['default_cost'];
    $default_shipping_cost = $default_cost;
  }else{
    $default_cost = $default_shipping_cost;
  }

  //$getOrder = mysqli_query($db,"SELECT * FROM `order_data` WHERE `orderID`='$orderID' AND `shop`='$shop'");
  //$getOrderRow = mysqli_fetch_array($getOrder);

  //$tempShipping_data = $getOrderRow['shipping_data'];
  $tempShipping_data = json_decode($shipping_data,true);

 // if ($globalOrdersShippingCost == null) {
    $getOrdersShippingCost = mysqli_query($db,"SELECT * FROM `shipping_cost_dynamic` WHERE `shop`='$shop'");
    $globalOrdersShippingCost = $getOrdersShippingCost;
  //}else{
   // $getOrdersShippingCost = $globalOrdersShippingCost;
  //}

  while ($getOrdersShippingCostRow = mysqli_fetch_array($getOrdersShippingCost)) {
    foreach ($tempShipping_data as $key => $shippingData) {
      if ($getOrdersShippingCostRow['key_search'] == $key && $getOrdersShippingCostRow['value_search'] == $shippingData) {
         $outputShippingCost = $getOrdersShippingCostRow['cost'];
      }
    }
  }

  if ($outputShippingCost == 0 || $outputShippingCost == null) {
    $outputShippingCost = $default_cost;
  }
  return $outputShippingCost;
}


function returnTransactionFee($orderID,$shop,$total_paid,$gateway){
  global $db;
  $outputTransactionFee = 0;

  //$getOrder = mysqli_query($db,"SELECT * FROM `order_data` WHERE `orderID`='$orderID' AND `shop`='$shop'");
  //$getOrderRow = mysqli_fetch_array($getOrder);
  //$tempTotalPaid = $getOrderRow['total_paid'];
  //$tempGateway = $getOrderRow['gateway'];

  $tempTotalPaid = $total_paid;
  $tempGateway = $gateway;

  //$getGatewayFee = mysqli_query($db,"SELECT * FROM `payment_fees` WHERE `gateway`='$tempGateway' AND `shop`='$shop'");
  //$getGatewayFeeRow = mysqli_fetch_array($getGatewayFee);
  $gatewayFeeObject = returnFeeArray($gateway,$shop);
  $gateway_percentage = $gatewayFeeObject['gateway_percentage'];
  $gateway_fixed = $gatewayFeeObject['gateway_fixed'];
  $external_gateway_percentage = $gatewayFeeObject['external_gateway_percentage'];

  $total_gateway_percentage = $tempTotalPaid*($gateway_percentage/100);
  $total_external_gateway_percentage = $tempTotalPaid*($external_gateway_percentage/100);

  $outputTransactionFee = $total_gateway_percentage+$total_external_gateway_percentage+$gateway_fixed;

  return $outputTransactionFee;
}

$globalFeeArray = [];
function returnFeeArray($gateway,$shop){
  global $db;
  global $globalFeeArray;
  if (empty($globalFeeArray)) {
    $getGatewayFee = mysqli_query($db,"SELECT * FROM `payment_fees` WHERE `shop`='$shop'");
    while ($getGatewayFeeRow = mysqli_fetch_array($getGatewayFee)) {
      $tempFee = [];
      $tempFee['gateway_percentage'] = $getGatewayFeeRow['gateway_percentage'];
      $tempFee['gateway_fixed'] = $getGatewayFeeRow['gateway_fixed'];
      $tempFee['external_gateway_percentage'] = $getGatewayFeeRow['external_gateway_percentage'];
      $tempFee['gateway'] = $getGatewayFeeRow['gateway'];
      $globalFeeArray[] = $tempFee;
    }
  }
  foreach ($globalFeeArray as $arrayFee) {
    if ($arrayFee['gateway'] == $gateway) {
      return $arrayFee;
    }
  }
}

function returnPercentage($val1,$val2){
  $output = 0;
  if ($val1 > 0 && $val2 > 0) {
    $output = round(($val1/$val2)*100);
  }else {
    $output = 0;
  }
  return $output;
}

function returnAverage($val1,$total){
  $output = 0;
  if ($val1 > 0 && $total > 0) {
    $output = $val1/$total;
  }else {
    $output = 0;
  }
  return $output;
}
?>
