<?php
include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/dbConn.php';
include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/Shopify/requestNoQuery.php';
include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/app/admin/menu.php';
include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/app/admin/statusCheck.php';

$shop = $_GET['shop'];
?>

<!DOCTYPE html>
<html lang="en" dir="ltr">
  <head>
    <meta charset="utf-8">
    <title>Metric Kings</title>

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>

    <link href="assets/css/jquery.gridstrap.css" rel="stylesheet" />
    <script src="assets/js/jquery.gridstrap.js"></script>
    <link href="assets/css/styles.css" rel="stylesheet" />
    <script src="https://kit.fontawesome.com/54f265a0f8.js" crossorigin="anonymous"></script>


    <link href="https://fonts.googleapis.com/css?family=Lato&display=swap" rel="stylesheet">
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <meta name="viewport" content="width=device-width, initial-scale=1">

  </head>
  <body>

    <?php mainMenu("settings"); ?>


    <div class="container" style="margin-top:100px;margin-bottom:100px;">
      <div class="col-md-12">
        <div class="row">
          <div class="col-md-12" style="text-align:center;margin-bottom:50px;">
            <h3>General Setup</h3>
            <p>Display your store Metrics in any currency.<br>Please contact us if you would like to update your Shopify store currency.</p>
          </div>
          <div class="col-md-12">
            <div class="row">
              <div class="col-md-6" style="text-align:center;">
                <p>Shopify Store Currency:</p>
                <select class="mt-select-main" name="store_currency" disabled style="cursor: not-allowed;">
                  <option value="AUD">(AUD) Australia Dollars</option>
                  <option value="CAD">(CAD) Canada Dollars</option>
                  <option value="CHF">(CHF) Switzerland Francs</option>
                  <option value="CNY">(CNY) China Yuan Renmimbi</option>
                  <option value="DKK">(DKK) Denmark Kroner</option>
                  <option value="EUR">(EUR) Euro</option>
                  <option value="GBP">(GBP) United Kingdom Pounds</option>
                  <option value="HKD">(HKD) Hong Kong Dollars</option>
                  <option value="HUF">(HUF) Hungary Forint</option>
                  <option value="IDR">(IDR) Indonesia Rupiah</option>
                  <option value="ILS">(ILS) Israel New Shekels</option>
                  <option value="INR">(INR) India Rupees</option>
                  <option value="ISK">(ISK) Iceland Krona</option>
                  <option value="JPY">(JPY) Japan Yen</option>
                  <option value="KRW">(KRW) Korea Won</option>
                  <option value="MYR">(MYR) Malaysia Ringgit</option>
                  <option value="NOK">(NOK) Norway Kroner</option>
                  <option value="NZD">(NZD) New Zealand Dollars</option>
                  <option value="PHP">(PHP) Philippines Pesos</option>
                  <option value="SEK">(SEK) Sweden Krona</option>
                  <option value="SGD">(SGD) Singapore Dollars</option>
                  <option value="THB">(THB) Thailand Baht</option>
                  <option value="USD">(USD) United States Dollars</option>
                  <option value="ZAR">(ZAR) South Africa Rand</option>
                </select>
              </div>
              <div class="col-md-6" style="text-align:center;">
                <p>Display Currency:</p>
                <select class="mt-select-main" name="display_currency">
                  <option value="AUD">(AUD) Australia Dollars</option>
                  <option value="CAD">(CAD) Canada Dollars</option>
                  <option value="CHF">(CHF) Switzerland Francs</option>
                  <option value="CNY">(CNY) China Yuan Renmimbi</option>
                  <option value="DKK">(DKK) Denmark Kroner</option>
                  <option value="EUR">(EUR) Euro</option>
                  <option value="GBP">(GBP) United Kingdom Pounds</option>
                  <option value="HKD">(HKD) Hong Kong Dollars</option>
                  <option value="HUF">(HUF) Hungary Forint</option>
                  <option value="IDR">(IDR) Indonesia Rupiah</option>
                  <option value="ILS">(ILS) Israel New Shekels</option>
                  <option value="INR">(INR) India Rupees</option>
                  <option value="ISK">(ISK) Iceland Krona</option>
                  <option value="JPY">(JPY) Japan Yen</option>
                  <option value="KRW">(KRW) Korea Won</option>
                  <option value="MYR">(MYR) Malaysia Ringgit</option>
                  <option value="NOK">(NOK) Norway Kroner</option>
                  <option value="NZD">(NZD) New Zealand Dollars</option>
                  <option value="PHP">(PHP) Philippines Pesos</option>
                  <option value="SEK">(SEK) Sweden Krona</option>
                  <option value="SGD">(SGD) Singapore Dollars</option>
                  <option value="THB">(THB) Thailand Baht</option>
                  <option value="USD">(USD) United States Dollars</option>
                  <option value="ZAR">(ZAR) South Africa Rand</option>
                </select>
              </div>
              <div class="col-md-12">
                <p class="success-msg">Successfully saved</p>
                <button type="button" class="mt-button" id="saveCurrency" name="button">Save</button>
              </div>
            </div>

          </div>

        </div>

      </div>
      <div class="mt-divider">

      </div>
      <div class="col-md-12">
        <div class="row">
          <div class="col-md-12" style="text-align:center;margin-bottom:50px;">
            <h3>Transaction Fee Setup</h3>
            <p>Please enter the fees you are being charged by your payment service provider.<br />
              NOTE: Payment provider's will only appear in this list once they have received an order.</p>
          </div>
          <!--<a target="_blank" class="dontFrame" href="http://marketappz.com/metric-kings/app/crons/orderSync.php?shop=<?php echo $shop; ?>">Resync orders</a>-->
          <div class="row">
            <?php
              $getFeeSetup = mysqli_query($db,"SELECT * FROM `payment_fees` WHERE `shop`='$shop'");
              while ($getFeeSetupRow = mysqli_fetch_array($getFeeSetup)) {
                $customClass = "";
                if ($getFeeSetupRow['gateway'] == 'shopify_payments') {
                  $customClass = "mt-hide-input";
                }
                echo '
                <div class="col-md-12 mt-feeRow '.$customClass.'">
                  <div class="row">
                    <div class="col-md-3">
                    <p class="mt-tansaction-title">Gateway Name</p>
                      <input type="text" class="mt-input-main" name="gateway" value="'.$getFeeSetupRow['gateway'].'" placeholder="Gateway name" disabled>
                    </div>
                    <div class="col-6 col-md-3">
                      <div class="col-md-12 noPaddCol">
                        <p class="mt-tansaction-title">Gateway Fee</p>
                      </div>
                      <div class="col-md-12 noPaddCol mt-percentage-input">
                        <input type="text" class="mt-input-main" name="gateway_percentage" value="'.$getFeeSetupRow['gateway_percentage'].'" placeholder="">
                        <div class="mt-percentage-icon">
                          <img class="" src="assets/images/percent.png" alt="">
                        </div>
                      </div>
                    </div>
                    <div class="col-6 col-md-3 ">
                      <div class="col-md-12 noPaddCol">
                        <p class="mt-tansaction-title">Gateway Fixed Fee</p>
                      </div>
                      <div class="col-md-12 noPaddCol mt-dollar-input">
                        <div class="mt-dollar-icon">
                          <img class="" src="assets/images/dollar.png" alt="">
                        </div>
                        <input type="text" class="mt-input-main" name="gateway_fixed" value="'.$getFeeSetupRow['gateway_fixed'].'" placeholder="">
                      </div>
                    </div>
                    <div class="col-md-3  mt-hide-input-child">
                      <div class="col-md-12 noPaddCol">
                        <p class="mt-tansaction-title">External Gateway Fee</p>
                      </div>
                      <div class="col-md-12 noPaddCol mt-percentage-input">
                        <input type="text" class="mt-input-main" name="external_gateway_percentage" value="'.$getFeeSetupRow['external_gateway_percentage'].'" placeholder="">
                        <div class="mt-percentage-icon">
                          <img class="" src="assets/images/percent.png" alt="">
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                ';
              }
            ?>
            <div class="col-md-12">
              <p class="success-msg">Successfully saved</p>
              <button type="button" class="mt-button" id="saveTransactionFees" name="button">Save</button>
            </div>
          </div>
        </div>
      </div>

      <div class="mt-divider">

      </div>

      <div class="row">
        <div class="col-md-12">
          <div class="col-md-12" style="text-align:center;margin-bottom:50px;">
            <h3>Default Shipping Cost</h3>
            <p>Please enter the default shipping cost for your Shopify site. The shipping rate is flat rate and applies to the whole order.<br />
              NOTE: If you have multiple shipping methods or calculations, they should be entered in the "Shipping Cost Criteria" section.</p>
            </p>
            <p class="success-msg">Successfully saved</p>
          </div>
          <div class="col-md-12">
            <div class="row">
              <div class="col-md-10 mt-dollar-input" style="max-height:70px;">
                <div class="mt-dollar-icon">
                  <img class="" src="assets/images/dollar.png" alt="">
                </div>
                <input type="text" style="max-width:100%;" class="mt-input-main" name="default_shipping_cost" value="" placeholder="Default Shipping Cost">
              </div>
              <div class="col-md-2">
                <button style="margin: 10px 0;width: 100%;" type="button" class="mt-button" id="saveDefaultShippingCost" name="button">Save</button>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="mt-divider">

      </div>

      <div class="row">
        <div class="col-md-12" style="text-align:center;margin-bottom:50px;">
          <h3>Shipping Cost Criteria</h3>
          <p>Enter any custom shipping options which can be applied in place of the default method above.<br />
          NOTE: Rates entered below will override the default shipping cost.</p>
          <button type="button" id="addShippingCost" style="margin-bottom: 0;" class="mt-button" name="button">Add Shipping Cost</button>
        </div>
        <div class="col-md-12">

          <div class="col-md-12" id="mt-shippingLines">


          </div>

          <div class="col-md-12">
            <p class="success-msg">Successfully saved</p>

            <button type="button" class="mt-button" id="saveShippingCost" name="button">Save</button>
          </div>
        </div>
      </div>



    </div>

    <script type="text/javascript">
    var saveTransactionFeeJSON = [];
      $("#saveTransactionFees").click(function() {
        var saveTransactionFeeJSON = [];

        $(".mt-feeRow").each(function() {
          saveTransactionFeeItem = {};
          $(this).find("input").each(function() {
            var tempArrayName = $(this).attr("name");
            var tempArrayValue = $(this).val();
            saveTransactionFeeItem[tempArrayName] = tempArrayValue;
          });
          saveTransactionFeeJSON.push(saveTransactionFeeItem);

        });

        jsonString = JSON.stringify(saveTransactionFeeJSON);

        $.ajax({
            type: "POST",
            url: "saveTransactionFees.php?shop=<?php echo $shop; ?>",
            data: jsonString,
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function(data){
              $("#saveTransactionFees").parent().find(".success-msg").fadeIn();
            }
        });
      });



      var saveShippingCostJSON = [];
        $("#saveShippingCost").click(function() {
          var saveShippingCostJSON = [];
          $(".mt-shipping-row").each(function() {
            saveShippingCostItem = {};
            $(this).find(".mt-JSON-merge").each(function() {

              var tempArrayName = $(this).attr("name");
              var tempArrayValue = $(this).val();
              saveShippingCostItem[tempArrayName] = tempArrayValue;

            });
            saveShippingCostJSON.push(saveShippingCostItem);

          });

          jsonString = JSON.stringify(saveShippingCostJSON);

          $.ajax({
              type: "POST",
              url: "saveShippingCost.php?shop=<?php echo $shop; ?>",
              data: jsonString,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function(data){
                $("#saveShippingCost").parent().find(".success-msg").fadeIn();
              }
          });
        });

        function createShippingLine(key = "",value = "",cost = "") {
          var guid = guidGenerator();
          $("#mt-shippingLines").append('<div class="row mt-shipping-row"> <div class="noPaddColMob col-4 col-md-4"> <select class="mt-JSON-merge mt-select-main" name="matching_key" data-ship-id="'+guid+'"> <option value="">Select Key</option> <option value="city">City</option><option value="shipping_method">Shipping Method</option> <option value="zip">Zip</option> <option value="province">Province</option> <option value="country">Country</option> <option value="country_code">Country Code</option> <option value="province_code">Province Code</option> </select> </div><div class="noPaddColMob col-4 col-md-4"> <input type="text" class="mt-JSON-merge mt-input-main" name="match_value" value="'+value+'" placeholder="Match Value"> </div><div class="noPaddColMob col-3 col-md-3 mt-dollar-input"> <div class="mt-dollar-icon"> <img class="" src="assets/images/dollar.png" alt=""> </div><input type="text" class="mt-JSON-merge mt-input-main" name="shipping_cost" value="'+cost+'" placeholder="Shipping Cost"> </div><div class="noPaddColMob col-1 col-md-1"><img class="mt-row-cross" src="assets/images/close.png" alt=""></div></div>');
          $('[data-ship-id="'+guid+'"]').val(key);
        }

        function guidGenerator() {
            var S4 = function() {
               return (((1+Math.random())*0x10000)|0).toString(16).substring(1);
            };
            return (S4()+S4()+"-"+S4()+"-"+S4()+"-"+S4()+"-"+S4()+S4()+S4());
        }



        <?php
          $getShippingSetup = mysqli_query($db,"SELECT * FROM `shipping_cost_dynamic` WHERE `shop`='$shop'");
          while ($getShippingSetupRow = mysqli_fetch_array($getShippingSetup)) {
            echo 'createShippingLine("'.$getShippingSetupRow['key_search'].'","'.$getShippingSetupRow['value_search'].'","'.$getShippingSetupRow['cost'].'");';

          }



          $getCurrency = mysqli_query($db,"SELECT * FROM `shopify_credentials` WHERE `shopify_shop`='$shop'");
          $getCurrencyRow = mysqli_fetch_array($getCurrency);
          $store_currency = $getCurrencyRow['store_currency'];
          $display_currency = $getCurrencyRow['display_currency'];

          echo 'var store_currency = "'.$store_currency.'";';
          echo 'var display_currency = "'.$display_currency.'";';


          $getDefaultCost = mysqli_query($db,"SELECT * FROM `default_shipping_cost` WHERE `shop`='$shop'");
          $getDefaultCostRow = mysqli_fetch_array($getDefaultCost);
          $getShippingDefaultCost = $getDefaultCostRow['default_cost'];
          echo 'var ShippingDefaultCost = "'.$getShippingDefaultCost.'";';


        ?>
        $("select[name='store_currency']").val(store_currency);
        $("select[name='display_currency']").val(display_currency);

        $("input[name='default_shipping_cost']").val(ShippingDefaultCost);



        $("#addShippingCost").click(function() {
          createShippingLine();
        });

        $(".mt-row-cross").click(function() {
          $(this).parent().parent().fadeOut(function() {
            $(this).remove();
          });
        });



        $("#saveCurrency").click(function() {
          var saveCurrencyJSON = {};
          saveCurrencyJSON['store_currency'] = $("select[name='store_currency']").val();
          saveCurrencyJSON['display_currency'] = $("select[name='display_currency']").val();

          jsonString = JSON.stringify(saveCurrencyJSON);

          $.ajax({
              type: "POST",
              url: "saveCurrency.php?shop=<?php echo $shop; ?>",
              data: jsonString,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function(data){
                $("#saveCurrency").parent().find(".success-msg").fadeIn();

              }
          });

        });

        $("#saveDefaultShippingCost").click(function() {
          var saveDefaultShippingJSON = {};
          saveDefaultShippingJSON['cost'] = $("input[name='default_shipping_cost']").val();

          saveDefaultShippingJSON = JSON.stringify(saveDefaultShippingJSON);

          $.ajax({
              type: "POST",
              url: "saveDefaultShipping.php?shop=<?php echo $shop; ?>",
              data: saveDefaultShippingJSON,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function(data){
                $("#saveDefaultShippingCost").parent().parent().parent().parent().find(".success-msg").fadeIn();
              }
          });
        });




    </script>
    <script src="assets/js/custom.js"></script>

  </body>
</html>
