<?php
include_once $_SERVER['DOCUMENT_ROOT'].'/metric-kings/dbConn.php';
include_once $_SERVER['DOCUMENT_ROOT'].'/metric-kings/Shopify/requestNoQuery.php';


function logOrderData($orderJSON,$shop){
  global $db;
  date_default_timezone_set('UTC');

  $orderID = $orderJSON['id'];
  $total_price = $orderJSON['total_price'];
  $shipping_price = $orderJSON['shipping_lines'][0]['price'];

  $order_longitude = $orderJSON['shipping_address']['longitude'];
  $order_latitude = $orderJSON['shipping_address']['latitude'];
  $country = returnRichText($orderJSON['shipping_address']['country']);

  $shipping_data = [];
  $shipping_data['city'] = returnRichText($orderJSON['shipping_address']['city']);
  $shipping_data['zip'] = returnRichText($orderJSON['shipping_address']['zip']);
  $shipping_data['province'] = returnRichText($orderJSON['shipping_address']['province']);
  $shipping_data['country'] = returnRichText($orderJSON['shipping_address']['country']);
  $shipping_data['country_code'] = returnRichText($orderJSON['shipping_address']['country_code']);
  $shipping_data['province_code'] = returnRichText($orderJSON['shipping_address']['province_code']);

  $shipping_data['shipping_method'] = returnRichText($orderJSON['shipping_lines'][0]['title']);

  $shipping_data = json_encode($shipping_data);

  $total_tax = $orderJSON['total_tax'];
  $currency = $orderJSON['currency'];
  $total_discounts = $orderJSON['total_discounts'];

  $gateway = $orderJSON['gateway'];

  $refund_total = 0;

  $created_at = $orderJSON['created_at'];
  $created_at = strtotime($created_at);

  $findorder = mysqli_query($db,"SELECT * FROM `order_data` WHERE `orderID`='$orderID' AND `shop`='$shop'");

  if (mysqli_num_rows($findorder) <= 0) {

    foreach ($orderJSON['refunds'] as $refund) {
      foreach ($refund['transactions'] as $orderTransactions) {
        if ($orderTransactions['kind'] == "refund") {
          $refund_temp = $orderTransactions['amount'];
          $refund_date = $orderTransactions['created_at'];
          $refund_date = strtotime($refund_date);
          $syncOrder = mysqli_query($db,"INSERT INTO `refund_data` (`shop`,`order_id`, `refund_date`, `refund_amount`) VALUES ('$shop','$orderID', '$refund_date', '$refund_temp');");
        }
      }
    }
    $orderTotalProducts = 0;
    $orderTotalCOGS = 0;

    foreach ($orderJSON['line_items'] as $orderLineItem) {
      $product_id = $orderLineItem['product_id'];
      $variant_id = $orderLineItem['variant_id'];
      $quantity = $orderLineItem['quantity'];
      $price = $orderLineItem['price'];

      $product_cost = returnProductCost($variant_id,$shop);

      $orderTotalCOGS = $orderTotalCOGS+($product_cost*$orderLineItem['quantity']);
      $orderTotalProducts = $orderTotalProducts+$orderLineItem['quantity'];
      $syncOrderProducts = mysqli_query($db,"INSERT INTO `order_line_items` (`shop`, `orderID`, `productID`, `variantID`, `product_cost`, `sale_price`, `quantity`) VALUES ('$shop', '$orderID', '$product_id', '$variant_id', '$product_cost', '$price', '$quantity');");
    }
    $syncOrder = mysqli_query($db,"INSERT INTO `order_data` (`shop`, `orderID`, `order_date`, `total_paid`, `shipping_charged`, `country`, `order_longitude`, `order_latitude`,`total_tax`,`currency`,`total_discounts`,`gateway`,`shipping_data`,`orderTotalCOGS`,`orderTotalProducts`) VALUES ('$shop', '$orderID', '$created_at', '$total_price', '$shipping_price', '$country', '$order_longitude', '$order_latitude','$total_tax','$currency','$total_discounts','$gateway','$shipping_data','$orderTotalCOGS','$orderTotalProducts');");

    $findPaymentMethod = mysqli_query($db,"SELECT * FROM `payment_fees` WHERE `gateway`='$gateway' AND `shop`='$shop'");
    if (mysqli_num_rows($findPaymentMethod) <= 0 && $gateway != "") {
      $syncPaymentMethods = mysqli_query($db,"INSERT INTO `payment_fees` (`shop`,`gateway`) VALUES ('$shop','$gateway');");
    }

  }
}

function returnProductCost($variant_id,$shop){
  global $db;

  $findProduct = mysqli_query($db,"SELECT * FROM `product_sync` WHERE `variantID`='$variant_id' AND `shop`='$shop'");
  $findProductRow = mysqli_fetch_array($findProduct);

  $output_product_cost = 0;
  $inventory_id = 0;

  if (mysqli_num_rows($findProduct) <= 0) {
    //Add product to db and return inventory id
  }else{
    $inventory_id = $findProductRow['inventoryID'];
  }

  $getInventoryPrice = ShopifyNoQueryGET("/admin/api/2019-10/inventory_items/$inventory_id.json",$shop);
  $getInventoryPrice = json_decode($getInventoryPrice,true);
  $output_product_cost = $getInventoryPrice['inventory_item']['cost'];
  if ($output_product_cost == null) {
    $output_product_cost = 0;
  }

  return $output_product_cost;
}

function returnRichText($text){
  return str_replace("'","",$text);
}

?>
