<?php


namespace Google\AdsApi\Examples\AdWords\v201809\AccountManagement;

require 'vendor/autoload.php';

use Google\AdsApi\AdWords\AdWordsServices;
use Google\AdsApi\AdWords\AdWordsSession;
use Google\AdsApi\AdWords\AdWordsSessionBuilder;
use Google\AdsApi\AdWords\v201809\cm\OrderBy;
use Google\AdsApi\AdWords\v201809\cm\Paging;
use Google\AdsApi\AdWords\v201809\cm\Selector;
use Google\AdsApi\AdWords\v201809\cm\SortOrder;
use Google\AdsApi\AdWords\v201809\mcm\ManagedCustomer;
use Google\AdsApi\AdWords\v201809\mcm\ManagedCustomerService;
use Google\AdsApi\Common\OAuth2TokenBuilder;

/**
 * This example gets the account hierarchy under the current account.
 */
class GetAccountHierarchy
{

    const PAGE_LIMIT = 500;

    public static function runExample(
        AdWordsServices $adWordsServices,
        AdWordsSession $session
    ) {
        $managedCustomerService = $adWordsServices->get(
            $session,
            ManagedCustomerService::class
        );
        global $outputIDs;


        // Create selector.
        $selector = new Selector();
        $selector->setFields(['CustomerId', 'Name']);
        $selector->setOrdering([new OrderBy('CustomerId', SortOrder::ASCENDING)]);
        $selector->setPaging(new Paging(0, self::PAGE_LIMIT));

        // Maps from customer IDs to accounts and links.
        $customerIdsToAccounts = [];
        $customerIdsToChildLinks = [];
        $customerIdsToParentLinks = [];

        $totalNumEntries = 0;
        do {
            // Make the get request.
            $page = $managedCustomerService->get($selector);

            // Create links between manager and clients.
            if ($page->getEntries() !== null) {
                $totalNumEntries = $page->getTotalNumEntries();
                if ($page->getLinks() !== null) {
                    foreach ($page->getLinks() as $link) {
                        // Cast the indexes to string to avoid the issue when 32-bit PHP
                        // automatically changes the IDs that are larger than the 32-bit max
                        // integer value to negative numbers.
                        $managerCustomerId = strval($link->getManagerCustomerId());
                        $customerIdsToChildLinks[$managerCustomerId][] = $link;
                        $clientCustomerId = strval($link->getClientCustomerId());
                        $customerIdsToParentLinks[$clientCustomerId] = $link;
                    }
                }
                foreach ($page->getEntries() as $account) {
                    $customerIdsToAccounts[strval($account->getCustomerId())] = $account;
                }
            }

            // Advance the paging index.
            $selector->getPaging()->setStartIndex(
                $selector->getPaging()->getStartIndex() + self::PAGE_LIMIT
            );
        } while ($selector->getPaging()->getStartIndex() < $totalNumEntries);

        // Find the root account.
        $rootAccount = null;
        foreach ($customerIdsToAccounts as $account) {
            if (!array_key_exists(
                $account->getCustomerId(),
                $customerIdsToParentLinks
            )) {
                $rootAccount = $account;
                break;
            }
        }

        if ($rootAccount !== null) {
            // Display results.
            self::printAccountHierarchy(
                $rootAccount,
                $customerIdsToAccounts,
                $customerIdsToChildLinks
            );


        } else {
            printf("No accounts were found.\n");
        }
        echo json_encode($outputIDs);
    }

    /**
     * Prints the specified account's hierarchy using recursion.
     *
     * @param ManagedCustomer $account the account to print
     * @param array $customerIdsToAccounts a map from customer IDs to accounts
     * @param array $customerIdsToChildLinks a map from customer IDs to child
     *     links
     * @param int|null $depth the current depth we are printing from in the
     *     account hierarchy; i.e., how far we've recursed
     */
    private static function printAccountHierarchy(
        $account,
        $customerIdsToAccounts,
        $customerIdsToChildLinks,
        $depth = null
    ) {
        //print str_repeat('-', $depth * 2);
        global $outputIDs;

        $customerId = $account->getCustomerId();
        //printf("%s, %s\n", $customerId, $account->getName());
        $tempAccount = [];
        $tempAccount['customerId'] = $customerId;
        $tempAccount['customerName'] = $account->getName();
        //$tempAccount['currency'] = $account->getCurrencyCode();
        $tempAccount['currency'] = "AUD";

        //var_dump($account);

        $outputIDs[] = $tempAccount;


        if (array_key_exists($customerId, $customerIdsToChildLinks)) {
            foreach ($customerIdsToChildLinks[strval($customerId)] as $childLink) {
                $childAccount = $customerIdsToAccounts[strval($childLink->getClientCustomerId())];
                self::printAccountHierarchy(
                    $childAccount,
                    $customerIdsToAccounts,
                    $customerIdsToChildLinks,
                    $depth + 1
                );
            }
        }

    }

    public static function main()
    {
        $outputIDs = [];
      include $_SERVER['DOCUMENT_ROOT'].'/metric-kings/dbConn.php';
      $shop = $_GET['shop'];

      $checkAddWords = mysqli_query($db,"SELECT * FROM `google_ads` WHERE `shop`='$shop'");
      $checkAddWordsRow = mysqli_fetch_array($checkAddWords);

$authFile = '[ADWORDS]
developerToken = "hXRde0gB9ZNBDLyXn43zFw"

[OAUTH2]
clientId = "732672859460-kh7sjsp3i4kpj4mipjl40es77pdalcj3.apps.googleusercontent.com"
clientSecret = "Ww2cs1WvsakCO0oZu_0rSgb6"
refreshToken = "'.$checkAddWordsRow['refresh_token'].'"';

              $fp = fopen("ini-files/$shop.ini","wb");
              fwrite($fp,$authFile);
              fclose($fp);


              // Generate a refreshable OAuth2 credential for authentication.
              $oAuth2Credential = (new OAuth2TokenBuilder())->fromFile("ini-files/$shop.ini")->build();
        // Construct an API session configured from a properties file and the
        // OAuth2 credentials above.
        $session = (new AdWordsSessionBuilder())->fromFile("ini-files/$shop.ini")->withOAuth2Credential($oAuth2Credential)->build();
        self::runExample(new AdWordsServices(), $session);

    }
}

GetAccountHierarchy::main();
