<?php
include $_SERVER['DOCUMENT_ROOT'].'/postcode-kings/dbConn.php';
include $_SERVER['DOCUMENT_ROOT'].'/postcode-kings/Shopify/request.php';
include $_SERVER['DOCUMENT_ROOT'].'/postcode-kings/app/admin/checkStatus.php';

$shop = $_GET['shop'];

?>

<!DOCTYPE html>
<html lang="en" dir="ltr">
  <head>
    <meta charset="utf-8">
    <title>Postcode Kings</title>

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>

    <link href="assets/css/jquery.gridstrap.css" rel="stylesheet" />
    <script src="assets/js/jquery.gridstrap.js"></script>
    <link href="assets/css/styles.css" rel="stylesheet" />
    <script src="https://kit.fontawesome.com/a16779149c.js" crossorigin="anonymous"></script>


    <link href="https://fonts.googleapis.com/css?family=Lato&display=swap" rel="stylesheet">
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Facebook Pixel Code -->
    <script>
      !function(f,b,e,v,n,t,s)
      {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
      n.callMethod.apply(n,arguments):n.queue.push(arguments)};
      if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
      n.queue=[];t=b.createElement(e);t.async=!0;
      t.src=v;s=b.getElementsByTagName(e)[0];
      s.parentNode.insertBefore(t,s)}(window, document,'script',
      'https://connect.facebook.net/en_US/fbevents.js');
      fbq('init', '681911879272404');
      fbq('track', 'PageView');
    </script>
    <noscript>
      <img height="1" width="1" style="display:none"
           src="https://www.facebook.com/tr?id=681911879272404&ev=PageView&noscript=1"/>
    </noscript>
    <!-- End Facebook Pixel Code -->
  </head>
  <body>

    <div class="mt-nav">
      <ul>
        <li><a href="index.php" class="active">Postcode Groups</a></li>
        <li><a href="createGroup.php">Create Group</a></li>
      </ul>
    </div>

    <div class="container" style="margin-top:100px;margin-bottom:100px;">

      <div class="row">
        <?php

        $getShop = mysqli_query($db,"SELECT * FROM shopify_credentials WHERE `shopify_shop`='$shop'");
        $getShopRow = mysqli_fetch_array($getShop);

        if ($getShopRow['carrier_shipping'] == false) {
          echo '
          <div class="col-md-12">
            <div class="mt-tutorial">
              <h3 style="margin-bottom: 20px;">Thank you for installing Postcode Kings</h3>
              <p>To use <strong>Postcode Kings</strong> you need to have the <strong>Carrier Calculated Shipping</strong> feature enabled in Shopify. To get this feature enabled please contact the Shopify live chat and they can enable this feature without having to upgrade to the Advanced Shopify plan.</p>
            </div>
          </div>
          ';

          $shippingEndpoint = '{
              "carrier_service": {
                "name": "Postcode Kings",
                "callback_url": "https://marketappz.com/postcode-kings/app/returnShipping.php",
                "service_discovery": true
              }
            }
          ';

          $carrier_service_response = ShopifyPOST('/admin/api/2019-10/carrier_services.json',$shippingEndpoint);
          $carrier_service_response = json_decode($carrier_service_response,true);

          if(array_key_exists("errors",$carrier_service_response)){
            //echo "Not Enabled";
            //$sql = mysqli_query($db,"UPDATE `shopify_credentials` SET `carrier_shipping` = '0' WHERE `shopify_shop` = '$shop'");
          }else{
            //echo "Enabled";
            $sql = mysqli_query($db,"UPDATE `shopify_credentials` SET `carrier_shipping` = '1' WHERE `shopify_shop` = '$shop'");
            echo '<script>
                    location.reload();
                  </script>';
          }
        }else{
          $checkGroups = mysqli_query($db,"SELECT * FROM `postcode_groups` WHERE `shop`='$shop'");
          if (mysqli_num_rows($checkGroups) <= 0) {
            echo '
            <div class="col-md-12">
              <div class="mt-tutorial">
                <h3 style="margin-bottom: 20px;">Welcome to Postcode Kings</h3>
                <p>Postcode Kings allows you to create shipping rates based on groups of postcodes/zipcodes.</p>
                <h4 style="margin: 40px 0 20px 0;">Getting Started</h4>
                <p>To get started you will need to <strong>create your first "Postcode Group"</strong>.</p>
                <p>This "Postcode Group" will include a selection of postcodes to which you can then apply shipping rates. These shipping rates can be,</p>
                <ul>
                  <li>weight based <em>or</em></li>
                  <li>flat rate</li>
                </ul>
                <p>Start by <a href="createGroup.php"">creating your first group</a>, then follow the steps to <strong>create shipping rates for that group</strong>.</p>
                <p><strong>Make sure to make your "Postcode Group" active once it has been created!</strong></p>
              </div>
            </div>
            ';
          }
        }






        ?>


        <div class="col-md-8" style="text-align:left;margin-bottom:30px;">
          <h3 style="margin-bottom:40px;">Postcode Groups</h3>
        </div>
        <div class="col-md-4" style="text-align:right;margin-bottom:30px;">
        <a class="mt-button" href="createGroup.php" title="Create Postcode Group">Create Group</a>
        </div>
        <div class="col-md-12">


          <table class="mt-table-styles">
            <tr>
               <th>Group Name</th>
               <th>Shipping Lines</th>
               <th style="width: 80px;">Active</th>
               <th style="width: 80px;">&nbsp;</th>
             </tr>

             <?php

              $getGroups = mysqli_query($db,"SELECT * FROM postcode_groups WHERE `shop` = '$shop'");
              while ($getGroupsRow = mysqli_fetch_array($getGroups)) {
                $groupID = $getGroupsRow['id'];
                $getLines = mysqli_query($db,"SELECT * FROM postcode_shipping_lines WHERE `groupID` = '$groupID'");
                $shippingLineCount = mysqli_num_rows($getLines);
                echo '
                  <tr>
                    <td>'.$getGroupsRow['group_name'].'</td>
                    <td>'.$shippingLineCount.'</td>
                    <td>';

                    if ($shippingLineCount>0) {
                      echo '
                        <label class="switch">
                          <input class="groupStatus" data-group-id="'.$getGroupsRow['id'].'" type="checkbox"';
                          if ($getGroupsRow['status'] == "active") {
                            echo "checked";
                          }
                          echo '>
                          <span class="slider round"></span>
                        </label>';
                    }else {
                      echo "You must create shipping lines to enable";
                    }




                      echo'
                    </td>
                    <td><a class="mt-btnEdit" style="" title="Edit Group" href="createGroup.php?groupID='.$getGroupsRow['id'].'"><i class="far fa-edit"></i></a><button class="mt-btnDel delete-group" style="" title="Remove Group" data-group-id="'.$getGroupsRow['id'].'"><i class="fas fa-trash"></i></Button></td>
                  </tr>
                ';
              }
              ?>

          </table>


        </div>
      </div>


    </div>

    <script type="text/javascript">
      $(".delete-group").click(function() {
        var tempGrouId = $(this).attr("data-group-id");
        $(this).parent().parent().fadeOut();
        $.post("deleteGroup.php?shop=<?php echo $shop; ?>",
         {
           groupID: tempGrouId,
         },
         function(data, status){
           //alert("Data: " + data + "\nStatus: " + status);
         });
      });

      $(".groupStatus").change(function() {
        var tempGroupId = $(this).attr("data-group-id");
        var tempStatus = "active";
        if ($(this).is(':checked')) {
          tempStatus = "active";
        }else{
          tempStatus = "inactive";
        }

        $.post("updateStatus.php?shop=<?php echo $shop; ?>",
         {
           groupID: tempGroupId,
           newStatus: tempStatus
         },
         function(data, status){
           //alert("Data: " + data + "\nStatus: " + status);
         });
      });


    </script>


    <script src="assets/js/custom.js"></script>

  </body>
</html>
