<?php
  include '../dbConn.php';
  include 'checkLogin.php';
  include 'menus.php';

  $user_avatar = $loggedUserData['user_avatar'];

  date_default_timezone_set('Australia/Brisbane');

  $date = date('d/m/Y', time());
  $time = date('h:i:s a', time());
  $username = $_SESSION["username"];
  $pageActive = "SHR";

?>

<!doctype html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang=""> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>ASRL Portal</title>
    <meta name="description" content="Ela Admin - HTML5 Admin Template">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="https://marketappz.com/asrl/admin/images/favicon.png">
    <link rel="shortcut icon" href="https://marketappz.com/asrl/admin/images/favicon.png">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/normalize.css@8.0.0/normalize.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/lykmapipo/themify-icons@0.1.2/css/themify-icons.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/pixeden-stroke-7-icon@1.2.3/pe-icon-7-stroke/dist/pe-icon-7-stroke.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.2.0/css/flag-icon.min.css">
    <link rel="stylesheet" href="assets/css/cs-skin-elastic.css">
    <link rel="stylesheet" href="assets/css/lib/datatable/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/custom.css">

    <style media="screen">
      .shrCon input{
        width: 100%;
        margin: 5px 0;
        height: 40px;
        padding: 0 10px;
        border: 1px solid #d2d2d2;
      }
      .shr-title p{
        margin: 0;
        margin-top: 10px;
      }
      .shrFinalCon input{
        width: 100%;
        margin: 5px 0;
        height: 40px;
        padding: 0 10px;
      }
      .li.subtitle{
        display: none!important;
      }
      #reportMSG{
        display: none;
      }
    </style>
    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>

    <!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv.min.js"></script> -->

</head>
<body>
    <!-- Left Panel -->

    <aside id="left-panel" class="left-panel">
        <nav class="navbar navbar-expand-sm navbar-default">

            <div id="main-menu" class="main-menu collapse navbar-collapse">
              <?php displayMainMenu(); ?>
            </div><!-- /.navbar-collapse -->
        </nav>
    </aside><!-- /#left-panel -->

    <!-- Left Panel -->

    <!-- Right Panel -->

    <div id="right-panel" class="right-panel">

        <!-- Header-->
        <header id="header" class="header">
            <div class="top-left">
                <div class="navbar-header">
                    <a class="navbar-brand" href="./"><img src="images/logo.png" alt="Logo"></a>
                    <a class="navbar-brand hidden" href="./"><img src="images/logo2.png" alt="Logo"></a>
                    <a id="menuToggle" class="menutoggle"><i class="fa fa-bars"></i></a>
                </div>
            </div>
            <div class="top-right">
                <div class="header-menu">
                    <div class="header-left">
                    </div>

                    <div class="user-area dropdown float-right">
                        <a href="#" class="dropdown-toggle active" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          <img class="user-avatar rounded-circle" src="<?php echo $user_avatar; ?>" alt="User Avatar">
                        </a>

                        <?php displayProfileMenu(); ?>

                    </div>
                </div>
            </div>
        </header><!-- /header -->
        <!-- Header-->


        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">SHR Calculator</strong>
                            </div>
                            <div class="card-body">
                              <form method="POST" id="shr-calculator" action="">
                                  <div class="row">
                                    <div class="shrCon col-md-6"><input name="Date" placeholder="Date" type="text" value="<?php echo $date; ?>" required></div>
                                    <div class="shrCon col-md-6"><input name="Time" placeholder="Time" type="text" value="<?php echo $time; ?>" class="" required></div>
                                    <div class="shrCon col-md-6"><input name="Venue" placeholder="Venue" type="text" required></div>
                                    <div class="shrCon col-md-6"><input name="WindDirection" placeholder="Wind Direction" type="text" required></div>
                                    <div class="shrCon col-md-6"><input name="Tide" placeholder="Tide" type="text" required></div>
                                    <div class="shrCon col-md-6"><input name="Observer" placeholder="Observer" type="text" value="<?php echo $username; ?>" required></div>

                                    <div class="col-md-12 shr-title"><p class="shrTitle">Wave Height Rating (WHR)</p></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveHt1" type="number" placeholder="<.5M = 1"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveHt2" type="number" placeholder="<1.0M = 2"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveHt3" type="number" placeholder="<1.5M = 3"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveHt4" type="number" placeholder="<2.0M = 4"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveHt5" type="number" placeholder="<2.5M = 5"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveHt6" type="number" placeholder="<3.0M = 6"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveHt7" type="number" placeholder="<3.5M = 8"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveHt8" type="number" placeholder="<4.0M = 10"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveHt9" type="number" placeholder="<4.5M = 12"></div>

                                    <div class="col-md-12 shr-title"><p class="shrTitle">Inner or Shore-break Rating (S-WHR)</p></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="S-WHR1" type="number" placeholder="<.5M = 0"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="S-WHR2" type="number" placeholder="<1.0M = 2"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="S-WHR3" type="number" placeholder="<1.5M = 3"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="S-WHR4" type="number" placeholder="<2.0M = 4"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="S-WHR5" type="number" placeholder="<2.5M = 5"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="S-WHR6" type="number" placeholder="<3.0M = 6"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="S-WHR7" type="number" placeholder="<3.5M = 8"></div>


                                    <div class="col-md-12 shr-title"><p class="shrTitle">Wave Type Rating (WTR)</p></div>

                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveType1" type="number" placeholder="Surging = 0"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveType2" type="number" placeholder="Spilling = 1"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveType3" type="number" placeholder="Plunging = 2"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WaveType4" type="number" placeholder="Plunging Back Blast = 4"></div>
                                    <div class="col-md-12 shr-title"><p class="shrTitle">Wave Period Rating (WPR)</p></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WPR1" type="number" placeholder=">14 sec = 0"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WPR2" type="number" placeholder="(9-14) sec = 1"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WPR3" type="number" placeholder="(6-8) sec = 2"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="WPR4" type="number" placeholder="(,6 sec) = 3"></div>

                                    <div class="col-md-12 shr-title"><p class="shrTitle">ZWR Outer Break</p></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWROuterBreak1" type="number" placeholder="<20M = 1"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWROuterBreak2" type="number" placeholder="< 40M = 2"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWROuterBreak3" type="number" placeholder="<60M = 3"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWROuterBreak4" type="number" placeholder="<80M = 4"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWROuterBreak5" type="number" placeholder="<100M = 5"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWROuterBreak6" type="number" placeholder="<120M = 6"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWROuterBreak7" type="number" placeholder="<140M = 7"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWROuterBreak8" type="number" placeholder="<160M = 8"></div>
                                    <div class="col-md-12 shr-title"><p class="shrTitle">ZWR Inner Break</p></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWRInnerBreak1" type="number" placeholder="<20M = 1"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWRInnerBreak2" type="number" placeholder="< 40M = 2"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWRInnerBreak3" type="number" placeholder="<60M = 3"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWRInnerBreak4" type="number" placeholder="<80M = 4"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWRInnerBreak5" type="number" placeholder="<100M = 5"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWRInnerBreak6" type="number" placeholder="<120M = 6"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWRInnerBreak7" type="number" placeholder="<140M = 7"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="ZWRInnerBreak8" type="number" placeholder="<160M = 8"></div>
                                    <div class="col-md-12 shr-title"><p class="shrTitle">Surface Turbulance Rating (STR)</p></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="STR1" type="number" placeholder="No Chop = 0"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="STR2" type="number" placeholder="(5-11kts) = 1"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="STR3" type="number" placeholder="(12-21kts) = 2"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="STR4" type="number" placeholder="(22-27kts) = 3"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="STR5" type="number" placeholder="(>27kts) = 4"></div>

                                    <div class="col-md-12 shr-title"><p class="shrTitle">Longshore Drift Rating (LDR)</p></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="LDR1" type="number" placeholder="No drag = 0"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="LDR2" type="number" placeholder="Low 40sec = 1"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="LDR3" type="number" placeholder="Mod 20-40 sec = 2"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="LDR4" type="number" placeholder="Strong 13-19 sec = 3"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="LDR5" type="number" placeholder="<13 sec = 4"></div>

                                    <div class="col-md-12 shr-title"><p class="shrTitle">Rip Current Rating (RCR)</p></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="RCR1" type="number" placeholder="Nil = 0"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="RCR2" type="number" placeholder="Mild Swim = 1"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="RCR3" type="number" placeholder="Walk Waist deep = 2"></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="RCR4" type="number" placeholder="Can't walk waist deep = 3"></div>

                                    <div class="col-md-12 shr-title"><p class="shrTitle">All other hazards like close to breakwall or drifting craft in race area = add 1. Surfboat = 6</p></div>
                                    <div class="shrCalVal shrCon col-md-6"><input name="other" type="number" placeholder="Other hazards"></div>

                                    <div class="col-md-12 shr-title"><p class="shrTitle">Calculated SHR:</p></div>
                                    <div class="shrFinalCon shrCon col-md-6"><input name="SHRValue" type="number" placeholder="SHR"></div>
                                    <div class="col-md-12">
                                      <div id="reportMSG" class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                                        <span class="badge badge-pill badge-success">Success</span>
                                        Report successful saved.
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                          <span aria-hidden="true">×</span>
                                        </button>
                                      </div>
                                    </div>
                                    <div class="col-md-12" style="margin-top:10px;">
                                      <button type="submit" class="btn btn-outline-primary">Save</button>
                                    </div>
                                  </div>
                              </form>
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->


        <div class="clearfix"></div>

        <footer class="site-footer">
            <div class="footer-inner bg-white">
                <div class="row">
                    <div class="col-sm-6">
                        Copyright &copy; <?php echo date("Y"); ?> ASRL
                    </div>
                </div>
            </div>
        </footer>

    </div><!-- /#right-panel -->

    <!-- Right Panel -->

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@2.2.4/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.4/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-match-height@0.7.2/dist/jquery.matchHeight.min.js"></script>
    <script src="assets/js/main.js"></script>


    <script src="assets/js/lib/data-table/datatables.min.js"></script>
    <script src="assets/js/lib/data-table/dataTables.bootstrap.min.js"></script>
    <script src="assets/js/lib/data-table/dataTables.buttons.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.bootstrap.min.js"></script>
    <script src="assets/js/lib/data-table/jszip.min.js"></script>
    <script src="assets/js/lib/data-table/vfs_fonts.js"></script>
    <script src="assets/js/lib/data-table/buttons.html5.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.print.min.js"></script>
    <script src="assets/js/lib/data-table/buttons.colVis.min.js"></script>
    <script src="assets/js/init/datatables-init.js"></script>


    <script type="text/javascript">
      $(document).ready(function() {
          $('#bootstrap-data-table-export').DataTable();

          $("#shr-calculator").submit(function(e) {
            var tempJSON = {};
            e.preventDefault();
            $(".shrCon").each(function() {
              var tempInputVal = $(this).find('input').val();
              var tempInputName = $(this).find('input').attr("name");
              tempJSON[tempInputName] = tempInputVal;
            });
            var outputJSON = JSON.stringify(tempJSON);
            jQuery.ajax({
                url: 'saveSHR.php?id=<?php echo $_GET['id']; ?>&customerToken=<?php echo $_SESSION["customerToken"]; ?>',
                type: 'post',
                dataType: 'json',
                data: outputJSON,
                success: function(data) {
                  $("#reportMSG").fadeIn();
                  setTimeout(function () {
                    window.location.replace("shr-reports.php");
                  }, 3000);
                }
            });
          });
          $(".shrCalVal input").change(function() {
            var curSHRVal = 0;
            $(".shrCalVal input").each(function() {
              var tempNumber = $(this).val();
              if (tempNumber == "") {
                tempNumber = 0;
              }else {
              }
              curSHRVal = curSHRVal+parseInt(tempNumber);
            });
            $(".shrFinalCon input").val(curSHRVal);
          });
      });
      var shrData = {};
      <?php

        if ($_GET['id'] != "") {
          $id = $_GET['id'];
          $getSHRData = mysqli_query($db,"SELECT * FROM `shr_data` WHERE `id`='$id'");
          $getSHRDataRow = mysqli_fetch_array($getSHRData);
          $JSON_data = $getSHRDataRow['JSON_data'];
          echo '
          shrData = '.$JSON_data.';
          ';
        }



      ?>
      $.each(shrData, function(i, item) {
          $("[name='"+i+"']").val(item);
      });

      $("[data-menu-id='<?php echo $pageActive; ?>']").addClass("active");

  </script>


</body>
</html>
